/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.zipkin;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.trace.api.TraceService;
import org.apache.eventmesh.trace.api.config.ExporterConfiguration;
import org.apache.eventmesh.trace.zipkin.config.ZipkinConfiguration;

public class ZipkinTraceService
implements TraceService {
    private static final String ENDPOINT_V2_SPANS = "/api/v2/spans";
    private final String serviceName = "eventmesh_trace";
    private String eventMeshZipkinIP;
    private int eventMeshZipkinPort;
    private int eventMeshTraceExportInterval;
    private int eventMeshTraceExportTimeout;
    private int eventMeshTraceMaxExportSize;
    private int eventMeshTraceMaxQueueSize;
    private SdkTracerProvider sdkTracerProvider;
    private OpenTelemetry openTelemetry;

    public void init() {
        this.eventMeshZipkinIP = ZipkinConfiguration.getEventMeshZipkinIP();
        this.eventMeshZipkinPort = ZipkinConfiguration.getEventMeshZipkinPort();
        this.eventMeshTraceExportInterval = ExporterConfiguration.getEventMeshTraceExportInterval();
        this.eventMeshTraceExportTimeout = ExporterConfiguration.getEventMeshTraceExportTimeout();
        this.eventMeshTraceMaxExportSize = ExporterConfiguration.getEventMeshTraceMaxExportSize();
        this.eventMeshTraceMaxQueueSize = ExporterConfiguration.getEventMeshTraceMaxQueueSize();
        String httpUrl = String.format("http://%s:%s", this.eventMeshZipkinIP, this.eventMeshZipkinPort);
        ZipkinSpanExporter zipkinExporter = ZipkinSpanExporter.builder().setEndpoint(httpUrl + ENDPOINT_V2_SPANS).build();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)zipkinExporter).setScheduleDelay((long)this.eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout((long)this.eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(this.eventMeshTraceMaxExportSize).setMaxQueueSize(this.eventMeshTraceMaxQueueSize).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        this.sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)spanProcessor).setResource(Resource.getDefault().merge(serviceNameResource)).build();
        this.openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(this.sdkTracerProvider).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)this.sdkTracerProvider).close()));
    }

    public void shutdown() {
        this.sdkTracerProvider.close();
    }

    public Tracer getTracer(String instrumentationName) {
        return this.openTelemetry.getTracer(instrumentationName);
    }

    public TextMapPropagator getTextMapPropagator() {
        return this.openTelemetry.getPropagators().getTextMapPropagator();
    }
}

