/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.grpc;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;

public class GrpcMessageProtocolResolver {
    public static CloudEvent buildEvent(SimpleMessage message) {
        String cloudEventJson = message.getContent();
        String contentType = message.getPropertiesOrDefault("contenttype", "application/cloudevents+json");
        EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
        CloudEvent event = eventFormat.deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
        RequestHeader header = message.getHeader();
        String env = StringUtils.isEmpty((CharSequence)header.getEnv()) ? event.getExtension("env").toString() : header.getEnv();
        String idc = StringUtils.isEmpty((CharSequence)header.getIdc()) ? event.getExtension("idc").toString() : header.getIdc();
        String ip = StringUtils.isEmpty((CharSequence)header.getIp()) ? event.getExtension("ip").toString() : header.getIp();
        String pid = StringUtils.isEmpty((CharSequence)header.getPid()) ? event.getExtension("pid").toString() : header.getPid();
        String sys = StringUtils.isEmpty((CharSequence)header.getSys()) ? event.getExtension("sys").toString() : header.getSys();
        String language = StringUtils.isEmpty((CharSequence)header.getLanguage()) ? event.getExtension("language").toString() : header.getLanguage();
        String protocolType = StringUtils.isEmpty((CharSequence)header.getProtocolType()) ? event.getExtension("protocoltype").toString() : header.getProtocolType();
        String protocolDesc = StringUtils.isEmpty((CharSequence)header.getProtocolDesc()) ? event.getExtension("protocoldesc").toString() : header.getProtocolDesc();
        String protocolVersion = StringUtils.isEmpty((CharSequence)header.getProtocolVersion()) ? event.getExtension("protocolversion").toString() : header.getProtocolVersion();
        String uniqueId = StringUtils.isEmpty((CharSequence)message.getUniqueId()) ? event.getExtension("uniqueid").toString() : message.getUniqueId();
        String seqNum = StringUtils.isEmpty((CharSequence)message.getSeqNum()) ? event.getExtension("seqnum").toString() : message.getSeqNum();
        String topic = StringUtils.isEmpty((CharSequence)message.getTopic()) ? event.getSubject() : message.getTopic();
        String username = StringUtils.isEmpty((CharSequence)header.getUsername()) ? event.getExtension("username").toString() : header.getUsername();
        String passwd = StringUtils.isEmpty((CharSequence)header.getPassword()) ? event.getExtension("passwd").toString() : header.getPassword();
        String ttl = StringUtils.isEmpty((CharSequence)message.getTtl()) ? event.getExtension("ttl").toString() : message.getTtl();
        String producerGroup = StringUtils.isEmpty((CharSequence)message.getProducerGroup()) ? event.getExtension("producergroup").toString() : message.getProducerGroup();
        Object eventBuilder = StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion) ? CloudEventBuilder.v1((CloudEvent)event) : CloudEventBuilder.v03((CloudEvent)event);
        eventBuilder.withSubject(topic).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", seqNum).withExtension("uniqueid", uniqueId).withExtension("producergroup", producerGroup).withExtension("ttl", ttl);
        message.getPropertiesMap().forEach((arg_0, arg_1) -> GrpcMessageProtocolResolver.lambda$buildEvent$0((CloudEventBuilder)eventBuilder, arg_0, arg_1));
        return eventBuilder.build();
    }

    public static SimpleMessageWrapper buildSimpleMessage(CloudEvent cloudEvent) {
        String env = cloudEvent.getExtension("env") == null ? "env" : cloudEvent.getExtension("env").toString();
        String idc = cloudEvent.getExtension("idc") == null ? "idc" : cloudEvent.getExtension("idc").toString();
        String ip = cloudEvent.getExtension("ip") == null ? "127.0.0.1" : cloudEvent.getExtension("ip").toString();
        String pid = cloudEvent.getExtension("pid") == null ? "123" : cloudEvent.getExtension("pid").toString();
        String sys = cloudEvent.getExtension("sys") == null ? "sys123" : cloudEvent.getExtension("sys").toString();
        String userName = cloudEvent.getExtension("username") == null ? "user" : cloudEvent.getExtension("username").toString();
        String passwd = cloudEvent.getExtension("passwd") == null ? "pass" : cloudEvent.getExtension("passwd").toString();
        String language = cloudEvent.getExtension("language") == null ? "JAVA" : cloudEvent.getExtension("language").toString();
        String protocol = cloudEvent.getExtension("protocoltype") == null ? "protocol" : cloudEvent.getExtension("protocoltype").toString();
        String protocolDesc = cloudEvent.getExtension("protocoldesc") == null ? "protocolDesc" : cloudEvent.getExtension("protocoldesc").toString();
        String protocolVersion = cloudEvent.getExtension("protocolversion") == null ? "1.0" : cloudEvent.getExtension("protocolversion").toString();
        String seqNum = cloudEvent.getExtension("seqnum") == null ? "" : cloudEvent.getExtension("seqnum").toString();
        String uniqueId = cloudEvent.getExtension("uniqueid") == null ? "" : cloudEvent.getExtension("uniqueid").toString();
        String producerGroup = cloudEvent.getExtension("producergroup") == null ? "producerGroup" : cloudEvent.getExtension("producergroup").toString();
        String ttl = cloudEvent.getExtension("ttl") == null ? "3000" : cloudEvent.getExtension("ttl").toString();
        RequestHeader header = RequestHeader.newBuilder().setEnv(env).setIdc(idc).setIp(ip).setPid(pid).setSys(sys).setUsername(userName).setPassword(passwd).setLanguage(language).setProtocolType(protocol).setProtocolDesc(protocolDesc).setProtocolVersion(protocolVersion).build();
        String contentType = cloudEvent.getDataContentType();
        EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
        SimpleMessage.Builder messageBuilder = SimpleMessage.newBuilder().setHeader(header).setContent(new String(eventFormat.serialize(cloudEvent), StandardCharsets.UTF_8)).setProducerGroup(producerGroup).setSeqNum(seqNum).setUniqueId(uniqueId).setTopic(cloudEvent.getSubject()).setTtl(ttl).putProperties("contenttype", contentType);
        for (String key : cloudEvent.getExtensionNames()) {
            messageBuilder.putProperties(key, cloudEvent.getExtension(key).toString());
        }
        SimpleMessage simpleMessage = messageBuilder.build();
        return new SimpleMessageWrapper(simpleMessage);
    }

    public static List<CloudEvent> buildBatchEvents(BatchMessage batchMessage) {
        ArrayList<CloudEvent> cloudEvents = new ArrayList<CloudEvent>();
        RequestHeader header = batchMessage.getHeader();
        for (BatchMessage.MessageItem item : batchMessage.getMessageItemList()) {
            String cloudEventJson = item.getContent();
            String contentType = item.getPropertiesOrDefault("contenttype", "application/cloudevents+json");
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
            CloudEvent event = eventFormat.deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
            String env = StringUtils.isEmpty((CharSequence)header.getEnv()) ? event.getExtension("env").toString() : header.getEnv();
            String idc = StringUtils.isEmpty((CharSequence)header.getIdc()) ? event.getExtension("idc").toString() : header.getIdc();
            String ip = StringUtils.isEmpty((CharSequence)header.getIp()) ? event.getExtension("ip").toString() : header.getIp();
            String pid = StringUtils.isEmpty((CharSequence)header.getPid()) ? event.getExtension("pid").toString() : header.getPid();
            String sys = StringUtils.isEmpty((CharSequence)header.getSys()) ? event.getExtension("sys").toString() : header.getSys();
            String language = StringUtils.isEmpty((CharSequence)header.getLanguage()) ? event.getExtension("language").toString() : header.getLanguage();
            String protocolType = StringUtils.isEmpty((CharSequence)header.getProtocolType()) ? event.getExtension("protocoltype").toString() : header.getProtocolType();
            String protocolDesc = StringUtils.isEmpty((CharSequence)header.getProtocolDesc()) ? event.getExtension("protocoldesc").toString() : header.getProtocolDesc();
            String protocolVersion = StringUtils.isEmpty((CharSequence)header.getProtocolVersion()) ? event.getExtension("protocolversion").toString() : header.getProtocolVersion();
            String username = StringUtils.isEmpty((CharSequence)header.getUsername()) ? event.getExtension("username").toString() : header.getUsername();
            String passwd = StringUtils.isEmpty((CharSequence)header.getPassword()) ? event.getExtension("passwd").toString() : header.getPassword();
            String seqNum = StringUtils.isEmpty((CharSequence)item.getSeqNum()) ? event.getExtension("seqnum").toString() : item.getSeqNum();
            String uniqueId = StringUtils.isEmpty((CharSequence)item.getUniqueId()) ? event.getExtension("uniqueid").toString() : item.getUniqueId();
            String topic = StringUtils.isEmpty((CharSequence)batchMessage.getTopic()) ? event.getSubject() : batchMessage.getTopic();
            String producerGroup = StringUtils.isEmpty((CharSequence)batchMessage.getProducerGroup()) ? event.getExtension("producergroup").toString() : batchMessage.getProducerGroup();
            String ttl = StringUtils.isEmpty((CharSequence)item.getTtl()) ? event.getExtension("ttl").toString() : item.getTtl();
            Object eventBuilder = StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion) ? CloudEventBuilder.v1((CloudEvent)event) : CloudEventBuilder.v03((CloudEvent)event);
            eventBuilder.withSubject(topic).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", seqNum).withExtension("uniqueid", uniqueId).withExtension("producergroup", producerGroup).withExtension("ttl", ttl);
            item.getPropertiesMap().forEach((arg_0, arg_1) -> GrpcMessageProtocolResolver.lambda$buildBatchEvents$1((CloudEventBuilder)eventBuilder, arg_0, arg_1));
            cloudEvents.add(eventBuilder.build());
        }
        return cloudEvents;
    }

    private static /* synthetic */ void lambda$buildBatchEvents$1(CloudEventBuilder eventBuilder, String k, String v) {
        eventBuilder.withExtension(k, v);
    }

    private static /* synthetic */ void lambda$buildEvent$0(CloudEventBuilder eventBuilder, String k, String v) {
        eventBuilder.withExtension(k, v);
    }
}

