/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class SendMessageRequestProtocolResolver {
    public static CloudEvent buildEvent(Header header, Body body) throws ProtocolHandleException {
        try {
            SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)header;
            SendMessageRequestBody sendMessageRequestBody = (SendMessageRequestBody)body;
            String protocolType = sendMessageRequestHeader.getProtocolType();
            String protocolDesc = sendMessageRequestHeader.getProtocolDesc();
            String protocolVersion = sendMessageRequestHeader.getProtocolVersion();
            String code = sendMessageRequestHeader.getCode();
            String env = sendMessageRequestHeader.getEnv();
            String idc = sendMessageRequestHeader.getIdc();
            String ip = sendMessageRequestHeader.getIp();
            String pid = sendMessageRequestHeader.getPid();
            String sys = sendMessageRequestHeader.getSys();
            String username = sendMessageRequestHeader.getUsername();
            String passwd = sendMessageRequestHeader.getPasswd();
            ProtocolVersion version = sendMessageRequestHeader.getVersion();
            String language = sendMessageRequestHeader.getLanguage();
            String producerGroup = sendMessageRequestBody.getProducerGroup();
            String content = sendMessageRequestBody.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                event = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(content.getBytes(StandardCharsets.UTF_8));
                event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)event).withExtension("code", code)).withExtension("env", env)).withExtension("idc", idc)).withExtension("ip", ip)).withExtension("pid", pid)).withExtension("sys", sys)).withExtension("username", username)).withExtension("passwd", passwd)).withExtension("version", version.getVersion())).withExtension("language", language)).withExtension("protocoltype", protocolType)).withExtension("protocoldesc", protocolDesc)).withExtension("protocolversion", protocolVersion)).withExtension("producergroup", producerGroup)).build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                event = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(content.getBytes(StandardCharsets.UTF_8));
                event = ((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)((CloudEventBuilder)io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)event).withExtension("code", code)).withExtension("env", env)).withExtension("idc", idc)).withExtension("ip", ip)).withExtension("pid", pid)).withExtension("sys", sys)).withExtension("username", username)).withExtension("passwd", passwd)).withExtension("version", version.getVersion())).withExtension("language", language)).withExtension("protocoltype", protocolType)).withExtension("protocoldesc", protocolDesc)).withExtension("protocolversion", protocolVersion)).withExtension("producergroup", producerGroup)).build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }
}

