/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.tcp;

import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.common.protocol.tcp.Command;

public class Header {
    private Command cmd;
    private int code;
    private String desc;
    private String seq;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Header() {
    }

    public Header(Command cmd, int code, String desc, String seq) {
        this.cmd = cmd;
        this.code = code;
        this.desc = desc;
        this.seq = seq;
    }

    public Header(int code, String desc, String seq, Map<String, Object> properties) {
        this.code = code;
        this.desc = desc;
        this.seq = seq;
        this.properties = properties;
    }

    public void putProperty(String name, Object value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (null == this.properties) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getStringProperty(String name) {
        Object property = this.getProperty(name);
        if (null == property) {
            return null;
        }
        return property.toString();
    }

    public Command getCmd() {
        return this.cmd;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSeq() {
        return this.seq;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCmd(Command cmd) {
        this.cmd = cmd;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Command this$cmd = this.getCmd();
        Command other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !((Object)((Object)this$cmd)).equals((Object)other$cmd)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$seq = this.getSeq();
        String other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !this$seq.equals(other$seq)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Command $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : ((Object)((Object)$cmd)).hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : $seq.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "Header(cmd=" + (Object)((Object)this.getCmd()) + ", code=" + this.getCode() + ", desc=" + this.getDesc() + ", seq=" + this.getSeq() + ", properties=" + this.getProperties() + ")";
    }
}

