/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.tcp;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class TcpMessageProtocolResolver {
    public static CloudEvent buildEvent(Header header, EventMeshMessage message) throws ProtocolHandleException {
        io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder;
        String protocolType = header.getProperty("protocoltype").toString();
        String protocolVersion = header.getProperty("protocolversion").toString();
        String protocolDesc = header.getProperty("protocoldesc").toString();
        if (StringUtils.isBlank((CharSequence)protocolType) || StringUtils.isBlank((CharSequence)protocolVersion) || StringUtils.isBlank((CharSequence)protocolDesc)) {
            throw new ProtocolHandleException(String.format("invalid protocol params protocolType %s|protocolVersion %s|protocolDesc %s", protocolType, protocolVersion, protocolDesc));
        }
        if (!StringUtils.equals((CharSequence)"eventmeshmessage", (CharSequence)protocolType)) {
            throw new ProtocolHandleException(String.format("Unsupported protocolType: %s", protocolType));
        }
        String topic = message.getTopic();
        String content = message.getBody();
        if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
            cloudEventBuilder = CloudEventBuilder.v1();
        } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
            cloudEventBuilder = CloudEventBuilder.v03();
        } else {
            throw new ProtocolHandleException(String.format("Unsupported protocolVersion: %s", protocolVersion));
        }
        cloudEventBuilder = cloudEventBuilder.withId(header.getSeq()).withSource(URI.create("/")).withType("eventmeshmessage").withSubject(topic).withData(content.getBytes(StandardCharsets.UTF_8));
        for (String propKey : header.getProperties().keySet()) {
            cloudEventBuilder.withExtension(propKey, header.getProperty(propKey).toString());
        }
        for (String propKey : message.getProperties().keySet()) {
            cloudEventBuilder.withExtension(propKey, (String)message.getProperties().get(propKey));
        }
        return cloudEventBuilder.build();
    }

    public static Package buildEventMeshMessage(CloudEvent cloudEvent) {
        EventMeshMessage eventMeshMessage = new EventMeshMessage();
        eventMeshMessage.setTopic(cloudEvent.getSubject());
        eventMeshMessage.setBody(new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8));
        HashMap<String, String> prop = new HashMap<String, String>();
        for (String extKey : cloudEvent.getExtensionNames()) {
            prop.put(extKey, cloudEvent.getExtension(extKey).toString());
        }
        eventMeshMessage.setProperties(prop);
        Package pkg = new Package();
        pkg.setBody((Object)eventMeshMessage);
        return pkg;
    }
}

