/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.admin.rocketmq.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.admin.rocketmq.request.TopicCreateRequest;
import org.apache.eventmesh.admin.rocketmq.util.JsonUtils;
import org.apache.eventmesh.admin.rocketmq.util.NetUtils;
import org.apache.eventmesh.admin.rocketmq.util.RequestMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicsHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(TopicsHandler.class);

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (RequestMapping.postMapping("/topicmanage", httpExchange)) {
            this.createTopicHandler(httpExchange);
            return;
        }
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.sendResponseHeaders(500, 0L);
        String result = String.format("Please check your request url", new Object[0]);
        logger.error(result);
        out.write(result.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTopicHandler(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            String params = NetUtils.parsePostBody(httpExchange);
            TopicCreateRequest topicCreateRequest = JsonUtils.toObject(params, TopicCreateRequest.class);
            String topic = topicCreateRequest.getName();
            if (StringUtils.isBlank((CharSequence)topic)) {
                result = "Create topic failed. Parameter topic not found.";
                logger.error(result);
                out.write(result.getBytes());
                return;
            }
            Object topicResponse = null;
            if (topicResponse != null) {
                logger.info("create a new topic: {}", (Object)topic);
                httpExchange.getResponseHeaders().add("Content-Type", "appication/json");
                httpExchange.sendResponseHeaders(200, 0L);
                result = JsonUtils.toJson(topicResponse);
                logger.info(result);
                out.write(result.getBytes());
                return;
            }
            httpExchange.sendResponseHeaders(500, 0L);
            result = String.format("create topic failed! Server side error", new Object[0]);
            logger.error(result);
            out.write(result.getBytes());
            return;
        }
        catch (Exception e) {
            httpExchange.getResponseHeaders().add("Content-Type", "appication/json");
            httpExchange.sendResponseHeaders(500, 0L);
            result = String.format("create topic failed! Server side error", new Object[0]);
            logger.error(result);
            out.write(result.getBytes());
            return;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

