/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.connector.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.connector.standalone.broker.model.MessageEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneProducer {
    private Logger logger = LoggerFactory.getLogger(StandaloneProducer.class);
    private StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();
    private AtomicBoolean isStarted = new AtomicBoolean(false);

    public StandaloneProducer(Properties properties) {
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
    }

    public StandaloneProducer init(Properties properties) throws Exception {
        return new StandaloneProducer(properties);
    }

    public SendResult publish(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent);
        try {
            MessageEntity messageEntity = this.standaloneBroker.putMessage(cloudEvent.getSubject(), cloudEvent);
            SendResult sendResult = new SendResult();
            sendResult.setTopic(cloudEvent.getSubject());
            sendResult.setMessageId(String.valueOf(messageEntity.getOffset()));
            return sendResult;
        }
        catch (Exception e) {
            this.logger.error("send message error, topic: {}", (Object)cloudEvent.getSubject(), (Object)e);
            throw new ConnectorRuntimeException(String.format("Send message error, topic: %s", cloudEvent.getSubject()));
        }
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        Preconditions.checkNotNull((Object)cloudEvent);
        Preconditions.checkNotNull((Object)sendCallback);
        try {
            SendResult sendResult = this.publish(cloudEvent);
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception ex) {
            OnExceptionContext onExceptionContext = OnExceptionContext.builder().messageId(cloudEvent.getId()).topic(cloudEvent.getSubject()).exception(new ConnectorRuntimeException((Throwable)ex)).build();
            sendCallback.onException(onExceptionContext);
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        this.publish(cloudEvent);
    }

    public void sendAsync(CloudEvent cloudEvent, SendCallback sendCallback) {
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"CloudEvent cannot be null");
        Preconditions.checkNotNull((Object)sendCallback, (Object)"Callback cannot be null");
        try {
            SendResult sendResult = this.publish(cloudEvent);
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception ex) {
            OnExceptionContext onExceptionContext = OnExceptionContext.builder().messageId(cloudEvent.getId()).topic(cloudEvent.getSubject()).exception(new ConnectorRuntimeException((Throwable)ex)).build();
            sendCallback.onException(onExceptionContext);
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new ConnectorRuntimeException("Request is not supported");
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new ConnectorRuntimeException("Reply is not supported");
    }

    public void checkTopicExist(String topic) throws Exception {
        boolean exist = this.standaloneBroker.checkTopicExist(topic);
        if (!exist) {
            throw new ConnectorRuntimeException(String.format("topic:%s is not exist", topic));
        }
    }

    public void setExtFields() {
    }
}

