/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.broker;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.eventmesh.connector.standalone.broker.model.MessageEntity;

public class MessageQueue {
    public MessageEntity[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public MessageQueue() {
        this(2048);
    }

    public MessageQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity is illegal");
        }
        this.items = new MessageEntity[capacity];
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public void put(MessageEntity messageEntity) throws InterruptedException {
        Preconditions.checkNotNull((Object)messageEntity);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.enqueue(messageEntity);
        }
        finally {
            lock.unlock();
        }
    }

    public MessageEntity take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            MessageEntity messageEntity = this.dequeue();
            return messageEntity;
        }
        finally {
            lock.unlock();
        }
    }

    public MessageEntity peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MessageEntity messageEntity = this.itemAt(this.takeIndex);
            return messageEntity;
        }
        finally {
            lock.unlock();
        }
    }

    public MessageEntity getHead() {
        return this.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEntity getTail() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == 0) {
                MessageEntity messageEntity = null;
                return messageEntity;
            }
            int tailIndex = this.putIndex - 1;
            if (tailIndex < 0) {
                tailIndex += this.items.length;
            }
            MessageEntity messageEntity = this.itemAt(tailIndex);
            return messageEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEntity getByOffset(long offset) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MessageEntity head = this.getHead();
            if (head == null) {
                MessageEntity messageEntity = null;
                return messageEntity;
            }
            if (head.getOffset() > offset) {
                throw new RuntimeException(String.format("The message has been deleted, offset: %s", offset));
            }
            MessageEntity tail = this.getTail();
            if (tail == null || tail.getOffset() < offset) {
                MessageEntity messageEntity = null;
                return messageEntity;
            }
            int offsetDis = (int)(head.getOffset() - offset);
            int offsetIndex = this.takeIndex - offsetDis;
            if (offsetIndex < 0) {
                offsetIndex += this.items.length;
            }
            MessageEntity messageEntity = this.itemAt(offsetIndex);
            return messageEntity;
        }
        finally {
            lock.unlock();
        }
    }

    public void removeHead() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == 0) {
                return;
            }
            this.items[this.takeIndex++] = null;
            if (this.takeIndex == this.items.length) {
                this.takeIndex = 0;
            }
            this.notFull.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public int getSize() {
        return this.count;
    }

    private MessageEntity itemAt(int index) {
        return this.items[index];
    }

    private void enqueue(MessageEntity messageEntity) {
        this.items[this.putIndex++] = messageEntity;
        if (this.putIndex == this.items.length) {
            this.putIndex = 0;
        }
        ++this.count;
        this.notEmpty.signal();
    }

    private MessageEntity dequeue() {
        MessageEntity item = this.items[this.takeIndex++];
        if (this.takeIndex == this.items.length) {
            this.takeIndex = 0;
        }
        this.notFull.signal();
        return item;
    }
}

