/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.LoadBalanceType;
import org.apache.eventmesh.common.loadbalance.Weight;

public class WeightRandomLoadBalanceSelector<T>
implements LoadBalanceSelector<T> {
    private final List<Weight<T>> clusterGroup;
    private final int totalWeight;
    private boolean sameWeightGroup = true;

    public WeightRandomLoadBalanceSelector(List<Weight<T>> clusterGroup) throws EventMeshException {
        if (CollectionUtils.isEmpty(clusterGroup)) {
            throw new EventMeshException("clusterGroup can not be empty");
        }
        int totalWeight = 0;
        int firstWeight = clusterGroup.get(0).getWeight();
        for (Weight<T> weight : clusterGroup) {
            totalWeight += weight.getWeight();
            if (!this.sameWeightGroup || firstWeight == weight.getWeight()) continue;
            this.sameWeightGroup = false;
        }
        this.clusterGroup = clusterGroup;
        this.totalWeight = totalWeight;
    }

    @Override
    public T select() {
        if (!this.sameWeightGroup) {
            int targetWeight = RandomUtils.nextInt((int)0, (int)this.totalWeight);
            for (Weight<T> weight : this.clusterGroup) {
                if ((targetWeight -= weight.getWeight()) >= 0) continue;
                return weight.getTarget();
            }
        }
        int length = this.clusterGroup.size();
        return this.clusterGroup.get(RandomUtils.nextInt((int)0, (int)length)).getTarget();
    }

    @Override
    public LoadBalanceType getType() {
        return LoadBalanceType.WEIGHT_RANDOM;
    }
}

