/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.concurrent.atomic.AtomicInteger;

public class Weight<T> {
    private T target;
    private final int weight;
    private final AtomicInteger currentWeight;

    public Weight(T target, int weight) {
        this.target = target;
        this.weight = weight;
        this.currentWeight = new AtomicInteger(0);
    }

    public void decreaseTotal(int total) {
        this.currentWeight.addAndGet(-1 * total);
    }

    public void increaseCurrentWeight() {
        this.currentWeight.addAndGet(this.weight);
    }

    public T getTarget() {
        return this.target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public int getWeight() {
        return this.weight;
    }

    public AtomicInteger getCurrentWeight() {
        return this.currentWeight;
    }

    public String toString() {
        return "Wight{target=" + this.target + ", weight=" + this.weight + ", currentWeight=" + this.currentWeight + '}';
    }
}

