/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.admin.rocketmq.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlMappingPattern {
    private static final String URL_PARAMETER_REGEX = "\\{(\\w*?)\\}";
    private static final String URL_PARAMETER_MATCH_REGEX = "\\([%\\\\w-.\\\\~!\\$&'\\\\(\\\\)\\\\*\\\\+,;=:\\\\[\\\\]@]+?\\)";
    private static final Pattern URL_PARAMETER_PATTERN = Pattern.compile("\\{(\\w*?)\\}");
    private static final String URL_FORMAT_REGEX = "(?:\\.\\{format\\})$";
    private static final String URL_FORMAT_MATCH_REGEX = "(?:\\\\.\\([\\\\w%]+?\\))?";
    private static final String URL_QUERY_STRING_REGEX = "(?:\\?.*?)?$";
    private String urlMappingPattern;
    private Pattern compiledUrlMappingPattern;
    private List<String> paramNames = new ArrayList<String>();

    public UrlMappingPattern(String pattern) {
        this.setUrlMappingPattern(pattern);
        this.compile();
    }

    public String getMappingPattern() {
        return this.getUrlMappingPattern().replaceFirst(URL_FORMAT_REGEX, "");
    }

    private String getUrlMappingPattern() {
        return this.urlMappingPattern;
    }

    public Map<String, String> extractPathParameterValues(String url) {
        Matcher matcher = this.compiledUrlMappingPattern.matcher(url);
        if (matcher.matches()) {
            return this.extractParameters(matcher);
        }
        return null;
    }

    public boolean matches(String url) {
        return this.extractPathParameterValues(url) != null;
    }

    public void compile() {
        this.acquireParamNames();
        String parsedPattern = this.getUrlMappingPattern().replaceFirst(URL_FORMAT_REGEX, URL_FORMAT_MATCH_REGEX);
        parsedPattern = parsedPattern.replaceAll(URL_PARAMETER_REGEX, URL_PARAMETER_MATCH_REGEX);
        this.compiledUrlMappingPattern = Pattern.compile(parsedPattern + URL_QUERY_STRING_REGEX);
    }

    private void acquireParamNames() {
        Matcher m = URL_PARAMETER_PATTERN.matcher(this.getUrlMappingPattern());
        while (m.find()) {
            this.paramNames.add(m.group(1));
        }
    }

    private Map<String, String> extractParameters(Matcher matcher) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String value = matcher.group(i + 1);
            if (value == null) continue;
            values.put(this.paramNames.get(i), value);
        }
        return values;
    }

    private void setUrlMappingPattern(String pattern) {
        this.urlMappingPattern = pattern;
    }

    public List<String> getParamNames() {
        return Collections.unmodifiableList(this.paramNames);
    }
}

