/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.rocketmq.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeReturnType;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.client.stat.ConsumerStatsManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.CMResult;
import org.apache.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.common.RemotingHelper;

public class ConsumeMessageConcurrentlyService
implements ConsumeMessageService {
    private static final InternalLogger log = ClientLogger.getLog();
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;
    private final DefaultMQPushConsumer defaultMQPushConsumer;
    private final MessageListenerConcurrently messageListener;
    private final BlockingQueue<Runnable> consumeRequestQueue;
    private final ThreadPoolExecutor consumeExecutor;
    private final String consumerGroup;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledExecutorService cleanExpireMsgExecutors;

    public ConsumeMessageConcurrentlyService(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl, MessageListenerConcurrently messageListener) {
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
        this.messageListener = messageListener;
        this.defaultMQPushConsumer = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer();
        this.consumerGroup = this.defaultMQPushConsumer.getConsumerGroup();
        this.consumeRequestQueue = new LinkedBlockingQueue<Runnable>();
        this.consumeExecutor = new ThreadPoolExecutor(this.defaultMQPushConsumer.getConsumeThreadMin(), this.defaultMQPushConsumer.getConsumeThreadMax(), 60000L, TimeUnit.MILLISECONDS, this.consumeRequestQueue, (ThreadFactory)new ThreadFactoryImpl("ConsumeMessageThread_" + this.consumerGroup + "_"));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("ConsumeMessageScheduledThread_"));
        this.cleanExpireMsgExecutors = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("CleanExpireMsgScheduledThread_"));
        log.info("new ConsumeMessageConcurrentlyService instance for eventMesh has been created ");
    }

    public void start() {
        if (this.defaultMQPushConsumer.getConsumeTimeout() > 0L) {
            this.cleanExpireMsgExecutors.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConsumeMessageConcurrentlyService.this.cleanExpireMsg();
                    }
                    catch (Exception e) {
                        log.warn("cleanExpireMsg ", (Throwable)e);
                    }
                }
            }, this.defaultMQPushConsumer.getConsumeTimeout(), this.defaultMQPushConsumer.getConsumeTimeout(), TimeUnit.MINUTES);
        }
    }

    public void shutdown(long awaitTerminateMillis) {
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        this.consumeExecutor.shutdown();
        this.cleanExpireMsgExecutors.shutdown();
    }

    public ThreadPoolExecutor getConsumeExecutor() {
        return this.consumeExecutor;
    }

    public void updateCorePoolSize(int corePoolSize) {
        if (corePoolSize > 0 && corePoolSize <= Short.MAX_VALUE && corePoolSize < this.defaultMQPushConsumer.getConsumeThreadMax()) {
            this.consumeExecutor.setCorePoolSize(corePoolSize);
        }
    }

    public void incCorePoolSize() {
    }

    public void decCorePoolSize() {
    }

    public int getCorePoolSize() {
        return this.consumeExecutor.getCorePoolSize();
    }

    public ConsumeMessageDirectlyResult consumeMessageDirectly(MessageExt msg, String brokerName) {
        ConsumeMessageDirectlyResult result = new ConsumeMessageDirectlyResult();
        result.setOrder(false);
        result.setAutoCommit(true);
        ArrayList<MessageExt> msgs = new ArrayList<MessageExt>();
        msgs.add(msg);
        MessageQueue mq = new MessageQueue();
        mq.setTopic(msg.getTopic());
        mq.setQueueId(msg.getQueueId());
        ProcessQueue pq = new ProcessQueue();
        EventMeshConsumeConcurrentlyContext context = new EventMeshConsumeConcurrentlyContext(mq, pq);
        this.resetRetryTopic(msgs);
        long beginTime = System.currentTimeMillis();
        log.info("consumeMessageDirectly receive new message: {}", (Object)msg);
        try {
            ConsumeConcurrentlyStatus status = this.messageListener.consumeMessage(msgs, (ConsumeConcurrentlyContext)context);
            if (status != null) {
                switch (status) {
                    case CONSUME_SUCCESS: {
                        result.setConsumeResult(CMResult.CR_SUCCESS);
                        break;
                    }
                    case RECONSUME_LATER: {
                        result.setConsumeResult(CMResult.CR_LATER);
                        break;
                    }
                }
            } else {
                result.setConsumeResult(CMResult.CR_RETURN_NULL);
            }
        }
        catch (Throwable e) {
            result.setConsumeResult(CMResult.CR_THROW_EXCEPTION);
            result.setRemark(RemotingHelper.exceptionSimpleDesc((Throwable)e));
            log.warn(String.format("consumeMessageDirectly exception: %s Group: %s Msgs: %s MQ: %s", RemotingHelper.exceptionSimpleDesc((Throwable)e), this.consumerGroup, msgs, mq), e);
        }
        result.setSpentTimeMills(System.currentTimeMillis() - beginTime);
        log.info("consumeMessageDirectly Result: {}", (Object)result);
        return result;
    }

    public void submitConsumeRequest(List<MessageExt> msgs, ProcessQueue processQueue, MessageQueue messageQueue, boolean dispatchToConsume) {
        int consumeBatchSize = this.defaultMQPushConsumer.getConsumeMessageBatchMaxSize();
        if (msgs.size() <= consumeBatchSize) {
            ConsumeRequest consumeRequest = new ConsumeRequest(msgs, processQueue, messageQueue);
            try {
                this.consumeExecutor.submit(consumeRequest);
            }
            catch (RejectedExecutionException e) {
                this.submitConsumeRequestLater(consumeRequest);
            }
        } else {
            int total = 0;
            while (total < msgs.size()) {
                ArrayList<MessageExt> msgThis = new ArrayList<MessageExt>(consumeBatchSize);
                for (int i = 0; i < consumeBatchSize && total < msgs.size(); ++i, ++total) {
                    msgThis.add(msgs.get(total));
                }
                ConsumeRequest consumeRequest = new ConsumeRequest(msgThis, processQueue, messageQueue);
                try {
                    this.consumeExecutor.submit(consumeRequest);
                }
                catch (RejectedExecutionException e) {
                    while (total < msgs.size()) {
                        msgThis.add(msgs.get(total));
                        ++total;
                    }
                    this.submitConsumeRequestLater(consumeRequest);
                }
            }
        }
    }

    public void resetRetryTopic(List<MessageExt> msgs) {
        String groupTopic = MixAll.getRetryTopic((String)this.consumerGroup);
        for (MessageExt msg : msgs) {
            String retryTopic = msg.getProperty("RETRY_TOPIC");
            if (retryTopic == null || !groupTopic.equals(msg.getTopic())) continue;
            msg.setTopic(retryTopic);
        }
    }

    private void cleanExpireMsg() {
        for (Map.Entry next : this.defaultMQPushConsumerImpl.getRebalanceImpl().getProcessQueueTable().entrySet()) {
            ProcessQueue pq = (ProcessQueue)next.getValue();
            pq.cleanExpiredMsg(this.defaultMQPushConsumer);
        }
    }

    public void processConsumeResult(ConsumeConcurrentlyStatus status, EventMeshConsumeConcurrentlyContext context, ConsumeRequest consumeRequest) {
        int ackIndex = context.getAckIndex();
        if (consumeRequest.getMsgs().isEmpty()) {
            return;
        }
        switch (status) {
            case CONSUME_SUCCESS: {
                if (ackIndex >= consumeRequest.getMsgs().size()) {
                    ackIndex = consumeRequest.getMsgs().size() - 1;
                }
                int ok = ackIndex + 1;
                int failed = consumeRequest.getMsgs().size() - ok;
                this.getConsumerStatsManager().incConsumeOKTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), (long)ok);
                this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), (long)failed);
                break;
            }
            case RECONSUME_LATER: {
                ackIndex = -1;
                this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), (long)consumeRequest.getMsgs().size());
                break;
            }
        }
        switch (this.defaultMQPushConsumer.getMessageModel()) {
            case BROADCASTING: {
                for (int i = ackIndex + 1; i < consumeRequest.getMsgs().size(); ++i) {
                    MessageExt msg = consumeRequest.getMsgs().get(i);
                    log.warn("BROADCASTING, the message consume failed, drop it, {}", (Object)msg.toString());
                }
                break;
            }
            case CLUSTERING: {
                ArrayList<MessageExt> msgBackFailed = new ArrayList<MessageExt>(consumeRequest.getMsgs().size());
                for (int i = ackIndex + 1; i < consumeRequest.getMsgs().size(); ++i) {
                    MessageExt msg = consumeRequest.getMsgs().get(i);
                    boolean result = this.sendMessageBack(msg, context);
                    if (result) continue;
                    msg.setReconsumeTimes(msg.getReconsumeTimes() + 1);
                    msgBackFailed.add(msg);
                }
                if (msgBackFailed.isEmpty()) break;
                consumeRequest.getMsgs().removeAll(msgBackFailed);
                this.submitConsumeRequestLater(msgBackFailed, consumeRequest.getProcessQueue(), consumeRequest.getMessageQueue());
                break;
            }
        }
        if (!context.isManualAck()) {
            this.updateOffset(consumeRequest.getMsgs(), context);
        }
    }

    public void updateOffset(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        for (MessageExt m : msgs) {
            log.debug("update offset, msg: {} {} {}", new Object[]{m.getTopic(), m.getQueueId(), m.getQueueOffset()});
        }
        MessageQueue messageQueue = context.getMessageQueue();
        ProcessQueue processQueue = ((EventMeshConsumeConcurrentlyContext)context).getProcessQueue();
        long offset = processQueue.removeMessage(msgs);
        if (offset >= 0L) {
            log.debug("update offset={}", (Object)offset);
            this.defaultMQPushConsumerImpl.getOffsetStore().updateOffset(messageQueue, offset, true);
        }
    }

    public ConsumerStatsManager getConsumerStatsManager() {
        return this.defaultMQPushConsumerImpl.getConsumerStatsManager();
    }

    public boolean sendMessageBack(MessageExt msg, ConsumeConcurrentlyContext context) {
        int delayLevel = context.getDelayLevelWhenNextConsume();
        try {
            this.defaultMQPushConsumerImpl.sendMessageBack(msg, delayLevel, context.getMessageQueue().getBrokerName());
            return true;
        }
        catch (Exception e) {
            log.error("sendMessageBack exception, group: " + this.consumerGroup + " msg: " + msg.toString(), (Throwable)e);
            return false;
        }
    }

    private void submitConsumeRequestLater(final List<MessageExt> msgs, final ProcessQueue processQueue, final MessageQueue messageQueue) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                ConsumeMessageConcurrentlyService.this.submitConsumeRequest(msgs, processQueue, messageQueue, true);
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    private void submitConsumeRequestLater(final ConsumeRequest consumeRequest) {
        final int times = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getMaxReconsumeTimes();
        log.warn("rejected by thread pool, try resubmit {} times, consumerGroup:{}", (Object)times, (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumerGroup());
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                boolean success = false;
                for (int i = 0; i < times; ++i) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ConsumeMessageConcurrentlyService.this.consumeExecutor.submit(consumeRequest);
                        success = true;
                        break;
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        continue;
                    }
                }
                if (!success) {
                    for (MessageExt messageExt : consumeRequest.getMsgs()) {
                        log.warn("discard rejected messages {} after retry {} times", (Object)messageExt, (Object)times);
                    }
                    consumeRequest.getProcessQueue().removeMessage(consumeRequest.getMsgs());
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    static {
        log.info("load custom ConsumeMessageConcurrentlyService class for eventMesh, because of updateOffset");
    }

    class ConsumeRequest
    implements Runnable {
        private final List<MessageExt> msgs;
        private final ProcessQueue processQueue;
        private final MessageQueue messageQueue;

        public ConsumeRequest(List<MessageExt> msgs, ProcessQueue processQueue, MessageQueue messageQueue) {
            this.msgs = msgs;
            this.processQueue = processQueue;
            this.messageQueue = messageQueue;
        }

        public List<MessageExt> getMsgs() {
            return this.msgs;
        }

        public ProcessQueue getProcessQueue() {
            return this.processQueue;
        }

        @Override
        public void run() {
            if (this.processQueue.isDropped()) {
                log.info("the message queue not be able to consume, because it's dropped. group={} {}", (Object)ConsumeMessageConcurrentlyService.this.consumerGroup, (Object)this.messageQueue);
                return;
            }
            MessageListenerConcurrently listener = ConsumeMessageConcurrentlyService.this.messageListener;
            EventMeshConsumeConcurrentlyContext context = new EventMeshConsumeConcurrentlyContext(this.messageQueue, this.processQueue);
            ConsumeConcurrentlyStatus status = null;
            ConsumeMessageContext consumeMessageContext = null;
            if (ConsumeMessageConcurrentlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                consumeMessageContext = new ConsumeMessageContext();
                consumeMessageContext.setConsumerGroup(ConsumeMessageConcurrentlyService.this.defaultMQPushConsumer.getConsumerGroup());
                consumeMessageContext.setProps(new HashMap());
                consumeMessageContext.setMq(this.messageQueue);
                consumeMessageContext.setMsgList(this.msgs);
                consumeMessageContext.setSuccess(false);
                ConsumeMessageConcurrentlyService.this.defaultMQPushConsumerImpl.executeHookBefore(consumeMessageContext);
            }
            long beginTimestamp = System.currentTimeMillis();
            boolean hasException = false;
            ConsumeReturnType returnType = ConsumeReturnType.SUCCESS;
            try {
                ConsumeMessageConcurrentlyService.this.resetRetryTopic(this.msgs);
                if (this.msgs != null && !this.msgs.isEmpty()) {
                    for (MessageExt msg : this.msgs) {
                        MessageAccessor.setConsumeStartTimeStamp((Message)msg, (String)String.valueOf(System.currentTimeMillis()));
                    }
                }
                status = listener.consumeMessage(Collections.unmodifiableList(this.msgs), (ConsumeConcurrentlyContext)context);
            }
            catch (Throwable e) {
                log.warn("consumeMessage exception: {} Group: {} Msgs: {} MQ: {}", new Object[]{RemotingHelper.exceptionSimpleDesc((Throwable)e), ConsumeMessageConcurrentlyService.this.consumerGroup, this.msgs, this.messageQueue});
                hasException = true;
            }
            long consumeRT = System.currentTimeMillis() - beginTimestamp;
            if (null == status) {
                returnType = hasException ? ConsumeReturnType.EXCEPTION : ConsumeReturnType.RETURNNULL;
            } else if (consumeRT >= ConsumeMessageConcurrentlyService.this.defaultMQPushConsumer.getConsumeTimeout() * 60L * 1000L) {
                returnType = ConsumeReturnType.TIME_OUT;
            } else if (ConsumeConcurrentlyStatus.RECONSUME_LATER == status) {
                returnType = ConsumeReturnType.FAILED;
            } else if (ConsumeConcurrentlyStatus.CONSUME_SUCCESS == status) {
                returnType = ConsumeReturnType.SUCCESS;
            }
            if (ConsumeMessageConcurrentlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                consumeMessageContext.getProps().put("ConsumeContextType", returnType.name());
            }
            if (null == status) {
                log.warn("consumeMessage return null, Group: {} Msgs: {} MQ: {}", new Object[]{ConsumeMessageConcurrentlyService.this.consumerGroup, this.msgs, this.messageQueue});
                status = ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            if (ConsumeMessageConcurrentlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                consumeMessageContext.setStatus(status.toString());
                consumeMessageContext.setSuccess(ConsumeConcurrentlyStatus.CONSUME_SUCCESS == status);
                ConsumeMessageConcurrentlyService.this.defaultMQPushConsumerImpl.executeHookAfter(consumeMessageContext);
            }
            ConsumeMessageConcurrentlyService.this.getConsumerStatsManager().incConsumeRT(ConsumeMessageConcurrentlyService.this.consumerGroup, this.messageQueue.getTopic(), consumeRT);
            ConsumeMessageConcurrentlyService.this.processConsumeResult(status, context, this);
        }

        public MessageQueue getMessageQueue() {
            return this.messageQueue;
        }
    }
}

