/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfiguration;
import org.apache.eventmesh.connector.rocketmq.consumer.PushConsumerImpl;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQConsumerImpl
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQConsumerImpl.class);
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private PushConsumerImpl pushConsumer;

    public synchronized void init(Properties keyValue) throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.init();
        boolean isBroadcast = Boolean.parseBoolean(keyValue.getProperty("isBroadcast"));
        String consumerGroup = keyValue.getProperty("consumerGroup");
        String instanceName = keyValue.getProperty("instanceName");
        if (isBroadcast) {
            consumerGroup = "broadcast-" + consumerGroup;
        }
        String namesrvAddr = clientConfiguration.namesrvAddr;
        Properties properties = new Properties();
        properties.put("ACCESS_POINTS", namesrvAddr);
        properties.put("REGION", "namespace");
        properties.put("instanceName", instanceName);
        properties.put("CONSUMER_ID", consumerGroup);
        if (isBroadcast) {
            properties.put("MESSAGE_MODEL", MessageModel.BROADCASTING.name());
        } else {
            properties.put("MESSAGE_MODEL", MessageModel.CLUSTERING.name());
        }
        this.pushConsumer = new PushConsumerImpl(properties);
    }

    public void subscribe(String topic, EventListener listener) throws Exception {
        this.pushConsumer.subscribe(topic, "*", listener);
    }

    public boolean isStarted() {
        return this.pushConsumer.isStarted();
    }

    public boolean isClosed() {
        return this.pushConsumer.isClosed();
    }

    public synchronized void start() {
        this.pushConsumer.start();
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        this.pushConsumer.updateOffset(cloudEvents, context);
    }

    public void unsubscribe(String topic) {
        this.pushConsumer.unsubscribe(topic);
    }

    public synchronized void shutdown() {
        this.pushConsumer.shutdown();
    }

    public Properties attributes() {
        return this.pushConsumer.attributes();
    }
}

