/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.rocketmq.common.EventMeshConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final Properties properties = new Properties();

    public static String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    private static String getConfigFilePath() {
        URL resource = ConfigurationWrapper.class.getClassLoader().getResource("rocketmq-client.properties");
        if (resource != null && new File(resource.getPath()).exists()) {
            return resource.getPath();
        }
        return EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + "rocketmq-client.properties";
    }

    private ConfigurationWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String configFile = ConfigurationWrapper.getConfigFilePath();
        log.info("loading config: {}", (Object)configFile);
        try {
            properties.load(new BufferedReader(new FileReader(configFile)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot load RocketMQ configuration file from :%s", configFile));
        }
    }
}

