/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.cloudevent.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import org.apache.eventmesh.connector.rocketmq.cloudevent.impl.RocketMQHeaders;
import org.apache.rocketmq.common.message.Message;

public final class RocketMQMessageWriter<R>
implements MessageWriter<CloudEventWriter<Message>, Message>,
CloudEventWriter<Message> {
    private Message message = new Message();

    public RocketMQMessageWriter(String topic) {
        this.message.setTopic(topic);
    }

    public RocketMQMessageWriter(String topic, String keys) {
        this.message.setTopic(topic);
        if (keys != null && keys.length() > 0) {
            this.message.setKeys(keys);
        }
    }

    public RocketMQMessageWriter(String topic, String keys, String tags) {
        this.message.setTopic(topic);
        if (tags != null && tags.length() > 0) {
            this.message.setTags(tags);
        }
        if (keys != null && keys.length() > 0) {
            this.message.setKeys(keys);
        }
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        this.message.putUserProperty(name, value);
        return this;
    }

    public RocketMQMessageWriter<R> create(SpecVersion version) {
        this.message.putUserProperty(RocketMQHeaders.SPEC_VERSION, version.toString());
        return this;
    }

    public Message setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.message.putUserProperty(RocketMQHeaders.CONTENT_TYPE, format.serializedContentType());
        this.message.setBody(value);
        return this.message;
    }

    public Message end(CloudEventData data) throws CloudEventRWException {
        this.message.setBody(data.toBytes());
        return this.message;
    }

    public Message end() {
        this.message.setBody(null);
        return this.message;
    }
}

