/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.admin.command;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.rocketmq.admin.command.Command;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTopicCommand
extends Command {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private int numOfQueue = 4;
    private int queuePermission = 6;
    private String topicName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.topicName)) {
            this.logger.error("Topic name can not be blank.");
            throw new Exception("Topic name can not be blank.");
        }
        try {
            this.init();
            this.adminExt.start();
            Set brokersAddr = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)this.adminExt, (String)this.clusterName);
            for (String masterAddr : brokersAddr) {
                TopicConfig topicConfig = new TopicConfig();
                topicConfig.setTopicName(this.topicName);
                topicConfig.setReadQueueNums(this.numOfQueue);
                topicConfig.setWriteQueueNums(this.numOfQueue);
                topicConfig.setPerm(this.queuePermission);
                this.adminExt.createAndUpdateTopicConfig(masterAddr, topicConfig);
                this.logger.info("Topic {} is created for RocketMQ broker {}", (Object)this.topicName, (Object)masterAddr);
            }
        }
        finally {
            this.adminExt.shutdown();
        }
    }

    public int getNumOfQueue() {
        return this.numOfQueue;
    }

    public int getQueuePermission() {
        return this.queuePermission;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setNumOfQueue(int numOfQueue) {
        this.numOfQueue = numOfQueue;
    }

    public void setQueuePermission(int permission) {
        this.queuePermission = permission;
    }
}

