/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolFactory {
    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, String threadName) {
        return ThreadPoolFactory.createThreadPoolExecutor(core, max, threadName, true);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, String threadName, boolean isDaemon) {
        return ThreadPoolFactory.createThreadPoolExecutor(core, max, new LinkedBlockingQueue<Runnable>(1000), threadName, isDaemon);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, BlockingQueue<Runnable> blockingQueue, String threadName, boolean isDaemon) {
        return new ThreadPoolExecutor(core, max, 10000L, TimeUnit.MILLISECONDS, blockingQueue, new ThreadFactoryBuilder().setNameFormat(threadName).setDaemon(isDaemon).build());
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, ThreadFactory threadFactory) {
        return ThreadPoolFactory.createThreadPoolExecutor(core, max, new LinkedBlockingQueue<Runnable>(1000), threadFactory);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(core, max, 10000L, TimeUnit.MILLISECONDS, blockingQueue, threadFactory);
    }

    public static ScheduledExecutorService createSingleScheduledExecutor(final String threadName) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private AtomicInteger ai = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadName + this.ai.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static ScheduledExecutorService createScheduledExecutor(int core, String threadName) {
        return ThreadPoolFactory.createScheduledExecutor(core, threadName, true);
    }

    public static ScheduledExecutorService createScheduledExecutor(int core, final String threadName, final boolean isDaemon) {
        return Executors.newScheduledThreadPool(core, new ThreadFactory(){
            private AtomicInteger ai = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadName + this.ai.incrementAndGet());
                thread.setDaemon(isDaemon);
                return thread;
            }
        });
    }

    public static ScheduledExecutorService createScheduledExecutor(int core, ThreadFactory threadFactory) {
        return Executors.newScheduledThreadPool(core, threadFactory);
    }
}

