/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.IPUtils;

public class CommonConfiguration {
    public String eventMeshEnv = "P";
    public String eventMeshIDC = "FT";
    public String eventMeshCluster = "LS";
    public String eventMeshName = "";
    public String sysID = "5477";
    public String eventMeshConnectorPluginType = "rocketmq";
    public String eventMeshSecurityPluginType = "security";
    public int eventMeshPrometheusPort = 19090;
    public String eventMeshRegistryPluginType = "namesrv";
    public String eventMeshTraceExporterType = "Log";
    public int eventMeshTraceExporterMaxExportSize = 512;
    public int eventMeshTraceExporterMaxQueueSize = 2048;
    public int eventMeshTraceExporterExportTimeout = 30;
    public int eventMeshTraceExporterExportInterval = 5;
    public String eventMeshTraceExportZipkinIp = "localhost";
    public int eventMeshTraceExportZipkinPort = 9411;
    public String namesrvAddr = "";
    public Integer eventMeshRegisterIntervalInMills = 10000;
    public Integer eventMeshFetchRegistryAddrInterval = 10000;
    public String eventMeshServerIp = null;
    public boolean eventMeshServerSecurityEnable = false;
    public boolean eventMeshServerRegistryEnable = false;
    protected ConfigurationWrapper configurationWrapper;

    public CommonConfiguration(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public void init() {
        if (this.configurationWrapper != null) {
            String eventMeshTraceExporterExportIntervalStr;
            String eventMeshTraceExporterExportTimeoutStr;
            String eventMeshTraceExporterMaxQueueSizeStr;
            String eventMeshEnvStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_ENV);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshEnvStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ENV));
            this.eventMeshEnv = StringUtils.deleteWhitespace((String)eventMeshEnvStr);
            String sysIdStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SYSID);
            Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)sysIdStr) && StringUtils.isNumeric((CharSequence)sysIdStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SYSID));
            this.sysID = StringUtils.deleteWhitespace((String)sysIdStr);
            String eventMeshClusterStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_CLUSTER);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshClusterStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_CLUSTER));
            this.eventMeshCluster = StringUtils.deleteWhitespace((String)eventMeshClusterStr);
            String eventMeshNameStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_NAME);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshNameStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_NAME));
            this.eventMeshName = StringUtils.deleteWhitespace((String)eventMeshNameStr);
            String eventMeshIdcStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_IDC);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshIdcStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_IDC));
            this.eventMeshIDC = StringUtils.deleteWhitespace((String)eventMeshIdcStr);
            String eventMeshPrometheusPortStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_METRICS_PROMETHEUS_PORT);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshPrometheusPortStr)) {
                this.eventMeshPrometheusPort = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshPrometheusPortStr));
            }
            this.eventMeshServerIp = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_HOST_IP);
            if (StringUtils.isBlank((CharSequence)this.eventMeshServerIp)) {
                this.eventMeshServerIp = IPUtils.getLocalAddress();
            }
            this.eventMeshConnectorPluginType = this.configurationWrapper.getProp(ConfKeys.KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.eventMeshConnectorPluginType), (Object)String.format("%s error", ConfKeys.KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE));
            String eventMeshServerAclEnableStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SECURITY_ENABLED);
            if (StringUtils.isNotBlank((CharSequence)eventMeshServerAclEnableStr)) {
                this.eventMeshServerSecurityEnable = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerAclEnableStr));
            }
            this.eventMeshSecurityPluginType = this.configurationWrapper.getProp(ConfKeys.KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.eventMeshSecurityPluginType), (Object)String.format("%s error", ConfKeys.KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE));
            String eventMeshServerRegistryEnableStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_ENABLED);
            if (StringUtils.isNotBlank((CharSequence)eventMeshServerRegistryEnableStr)) {
                this.eventMeshServerRegistryEnable = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerRegistryEnableStr));
            }
            this.eventMeshRegistryPluginType = this.configurationWrapper.getProp(ConfKeys.KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.eventMeshRegistryPluginType), (Object)String.format("%s error", ConfKeys.KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE));
            String eventMeshTraceExporterTypeStr = this.configurationWrapper.getProp(ConfKeys.KEYS_ENENTMESH_TRACE_EXPORTER_TYPE);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshTraceExporterTypeStr), (Object)String.format("%s error", ConfKeys.KEYS_ENENTMESH_TRACE_EXPORTER_TYPE));
            this.eventMeshTraceExporterType = StringUtils.deleteWhitespace((String)eventMeshTraceExporterTypeStr);
            String eventMeshTraceExporterMaxExportSizeStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORTER_MAX_EXPORT_SIZE);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshTraceExporterMaxExportSizeStr)) {
                this.eventMeshTraceExporterMaxExportSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTraceExporterMaxExportSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceExporterMaxQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORTER_MAX_QUEUE_SIZE)))) {
                this.eventMeshTraceExporterMaxQueueSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTraceExporterMaxQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceExporterExportTimeoutStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORTER_EXPORT_TIMEOUT)))) {
                this.eventMeshTraceExporterExportTimeout = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTraceExporterExportTimeoutStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceExporterExportIntervalStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORTER_EXPORT_INTERVAL)))) {
                this.eventMeshTraceExporterExportInterval = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTraceExporterExportIntervalStr));
            }
            String eventMeshTraceExportZipkinIpStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORT_ZIPKIN_IP);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshTraceExportZipkinIpStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_TRACE_EXPORT_ZIPKIN_IP));
            this.eventMeshTraceExportZipkinIp = StringUtils.deleteWhitespace((String)eventMeshTraceExportZipkinIpStr);
            String eventMeshTraceExportZipkinPortStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_TRACE_EXPORT_ZIPKIN_PORT);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshTraceExportZipkinPortStr)) {
                this.eventMeshTraceExportZipkinPort = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTraceExportZipkinPortStr));
            }
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_ENV = "eventMesh.server.env";
        public static String KEYS_EVENTMESH_IDC = "eventMesh.server.idc";
        public static String KEYS_EVENTMESH_SYSID = "eventMesh.sysid";
        public static String KEYS_EVENTMESH_SERVER_CLUSTER = "eventMesh.server.cluster";
        public static String KEYS_EVENTMESH_SERVER_NAME = "eventMesh.server.name";
        public static String KEYS_EVENTMESH_SERVER_HOST_IP = "eventMesh.server.hostIp";
        public static String KEYS_EVENTMESH_SERVER_REGISTER_INTERVAL = "eventMesh.server.registry.registerIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_FETCH_REGISTRY_ADDR_INTERVAL = "eventMesh.server.registry.fetchRegistryAddrIntervalInMills";
        public static String KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE = "eventMesh.connector.plugin.type";
        public static String KEYS_EVENTMESH_SECURITY_ENABLED = "eventMesh.server.security.enabled";
        public static String KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE = "eventMesh.security.plugin.type";
        public static String KEY_EVENTMESH_METRICS_PROMETHEUS_PORT = "eventMesh.metrics.prometheus.port";
        public static String KEYS_EVENTMESH_REGISTRY_ENABLED = "eventMesh.server.registry.enabled";
        public static String KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE = "eventMesh.registry.plugin.type";
        public static String KEYS_ENENTMESH_TRACE_EXPORTER_TYPE = "eventmesh.trace.exporter.type";
        public static String KEYS_EVENTMESH_TRACE_EXPORTER_MAX_EXPORT_SIZE = "eventmesh.trace.exporter.max.export.size";
        public static String KEYS_EVENTMESH_TRACE_EXPORTER_MAX_QUEUE_SIZE = "eventmesh.trace.exporter.max.queue.size";
        public static String KEYS_EVENTMESH_TRACE_EXPORTER_EXPORT_TIMEOUT = "eventmesh.trace.exporter.export.timeout";
        public static String KEYS_EVENTMESH_TRACE_EXPORTER_EXPORT_INTERVAL = "eventmesh.trace.exporter.export.interval";
        public static String KEYS_EVENTMESH_TRACE_EXPORT_ZIPKIN_IP = "eventmesh.trace.export.zipkin.ip";
        public static String KEYS_EVENTMESH_TRACE_EXPORT_ZIPKIN_PORT = "eventmesh.trace.export.zipkin.port";

        ConfKeys() {
        }
    }
}

