/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static Map<String, String> formData2Dic(String formData) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (formData == null || formData.trim().length() == 0) {
            return result;
        }
        String[] items = formData.split("&");
        Arrays.stream(items).forEach(item -> {
            String[] keyAndVal = item.split("=");
            if (keyAndVal.length == 2) {
                try {
                    String key = URLDecoder.decode(keyAndVal[0], "utf8");
                    String val = URLDecoder.decode(keyAndVal[1], "utf8");
                    result.put(key, val);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("formData2Dic:param decode failed...", (Throwable)e);
                }
            }
        });
        return result;
    }

    public static String addressToString(List<InetSocketAddress> clients) {
        if (clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }
}

