/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.trace;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.runtime.exporter.EventMeshExporter;
import org.apache.eventmesh.runtime.exporter.LogExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryTraceFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryTraceFactory.class);
    private final String serviceName = "eventmesh_trace";
    private OpenTelemetry openTelemetry;
    private SpanExporter spanExporter;
    private SpanExporter defaultExporter = new LogExporter();
    private SpanProcessor spanProcessor;

    public OpenTelemetryTraceFactory(CommonConfiguration configuration) {
        try {
            String exporterName = configuration.eventMeshTraceExporterType;
            String className = String.format("org.apache.eventmesh.runtime.exporter.%sExporter", exporterName);
            EventMeshExporter eventMeshExporter = (EventMeshExporter)Class.forName(className).newInstance();
            this.spanExporter = eventMeshExporter.getSpanExporter(configuration);
        }
        catch (Exception ex) {
            logger.error("fail to set tracer's exporter,due to {}", (Object)ex.getMessage());
            this.spanExporter = this.defaultExporter;
            logger.info("change to use the default exporter {}", this.defaultExporter.getClass());
        }
        this.spanProcessor = BatchSpanProcessor.builder((SpanExporter)this.spanExporter).setMaxExportBatchSize(configuration.eventMeshTraceExporterMaxExportSize).setMaxQueueSize(configuration.eventMeshTraceExporterMaxQueueSize).setExporterTimeout((long)configuration.eventMeshTraceExporterExportTimeout, TimeUnit.SECONDS).setScheduleDelay((long)configuration.eventMeshTraceExporterExportInterval, TimeUnit.SECONDS).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor(this.spanProcessor).setResource(Resource.getDefault().merge(serviceNameResource)).build();
        this.openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(sdkTracerProvider).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)sdkTracerProvider).close()));
    }

    public Tracer getTracer(String instrumentationName) {
        return this.openTelemetry.getTracer(instrumentationName);
    }

    public TextMapPropagator getTextMapPropagator() {
        return this.openTelemetry.getPropagators().getTextMapPropagator();
    }
}

