/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.registry;

import java.util.List;
import java.util.Map;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static final Logger logger = LoggerFactory.getLogger(Registry.class);
    private static RegistryService registryService;

    public void init(String registryPluginType) throws Exception {
        registryService = (RegistryService)EventMeshExtensionFactory.getExtension(RegistryService.class, (String)registryPluginType);
        if (registryService == null) {
            logger.error("can't load the registryService plugin, please check.");
            throw new RuntimeException("doesn't load the registryService plugin, please check.");
        }
        registryService.init();
    }

    public void start() throws Exception {
        registryService.start();
    }

    public void shutdown() throws Exception {
        registryService.shutdown();
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws Exception {
        return registryService.findEventMeshInfoByCluster(clusterName);
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws Exception {
        return registryService.findEventMeshClientDistributionData(clusterName, group, purpose);
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws Exception {
        return registryService.register(eventMeshRegisterInfo);
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws Exception {
        return registryService.unRegister(eventMeshUnRegisterInfo);
    }
}

