/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.opentelemetry;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpConnectionHandler;
import org.apache.eventmesh.runtime.metrics.opentelemetry.OpenTelemetryPrometheusExporter;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMonitor;

public class OpenTelemetryTCPMetricsExporter {
    private final EventMeshTcpMonitor eventMeshTcpMonitor;

    public OpenTelemetryTCPMetricsExporter(EventMeshTcpMonitor eventMeshTcpMonitor, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        OpenTelemetryPrometheusExporter.initialize(eventMeshTCPConfiguration);
        this.eventMeshTcpMonitor = eventMeshTcpMonitor;
    }

    public void start() {
        Meter meter = GlobalMeterProvider.getMeter((String)"apache-eventmesh");
        meter.doubleValueObserverBuilder("eventmesh.tcp.retry.queue.size").setDescription("get size of retry queue.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getEventMeshTCPServer().getEventMeshTcpRetryer().getRetrySize(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.server.tps").setDescription("get tps of client to eventMesh.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getClient2eventMeshTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.mq.provider.tps").setDescription("get tps of eventMesh to mq.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getEventMesh2mqTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.mq.consumer.tps").setDescription("get tps of mq to eventMesh.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getMq2eventMeshTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.client.tps").setDescription("get tps of eventMesh to client.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getEventMesh2clientTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.all.tps").setDescription("get all TPS.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getAllTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.connection.num").setDescription("EventMeshTcpConnectionHandler.connections.").setUnit("TCP").setUpdater(result -> result.observe(EventMeshTcpConnectionHandler.connections.doubleValue(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.sub.topic.num").setDescription("get sub topic num.").setUnit("TCP").setUpdater(result -> result.observe((double)this.eventMeshTcpMonitor.getSubTopicNum(), Labels.empty())).build();
    }

    public void shutdown() {
        OpenTelemetryPrometheusExporter.shutdown();
    }
}

