/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.opentelemetry;

import io.opentelemetry.exporter.prometheus.PrometheusCollector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryPrometheusExporter {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryPrometheusExporter.class);
    private static HTTPServer server;

    public static synchronized void initialize(CommonConfiguration configuration) {
        if (server != null) {
            return;
        }
        PrometheusCollector.builder().setMetricProducer((MetricProducer)SdkMeterProvider.builder().buildAndRegisterGlobal()).buildAndRegister();
        int port = configuration.eventMeshPrometheusPort;
        try {
            server = new HTTPServer(port, true);
        }
        catch (IOException e) {
            logger.error("failed to start prometheus server, port: {} due to {}", (Object)port, (Object)e.getMessage());
        }
    }

    public static void shutdown() {
        if (server != null) {
            server.stop();
            server = null;
        }
    }
}

