/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendTask
extends AbstractTask {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");

    public RecommendTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        try {
            if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerRegistryEnable) {
                throw new Exception("registry enable config is false, not support");
            }
            UserAgent user = (UserAgent)this.pkg.getBody();
            this.validateUserAgent(user);
            String group = this.getGroupOfClient(user);
            EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
            String eventMeshRecommendResult = eventMeshRecommendStrategy.calculateRecommendEventMesh(group, user.getPurpose());
            res.setHeader(new Header(Command.RECOMMEND_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
            res.setBody((Object)eventMeshRecommendResult);
        }
        catch (Exception e) {
            this.messageLogger.error("RecommendTask failed|address={}|errMsg={}", (Object)this.ctx.channel().remoteAddress(), (Object)e);
            res.setHeader(new Header(Command.RECOMMEND_RESPONSE, OPStatus.FAIL.getCode().intValue(), e.toString(), this.pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(res, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
        }
    }

    private void validateUserAgent(UserAgent user) throws Exception {
        if (user == null) {
            throw new Exception("client info cannot be null");
        }
        if (user.getVersion() == null) {
            throw new Exception("client version cannot be null");
        }
        if (user.getUsername() == null) {
            throw new Exception("client wemqUser cannot be null");
        }
        if (user.getPassword() == null) {
            throw new Exception("client wemqPasswd cannot be null");
        }
        if (!StringUtils.equals((CharSequence)"pub", (CharSequence)user.getPurpose()) && !StringUtils.equals((CharSequence)"sub", (CharSequence)user.getPurpose())) {
            throw new Exception("client purpose config is error");
        }
    }

    private String getGroupOfClient(UserAgent userAgent) {
        if (userAgent == null) {
            return null;
        }
        if ("pub".equals(userAgent.getPurpose())) {
            return userAgent.getProducerGroup();
        }
        if ("sub".equals(userAgent.getPurpose())) {
            return userAgent.getConsumerGroup();
        }
        return null;
    }
}

