/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.DownstreamDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePriorityDispatchStrategy
implements DownstreamDispatchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(FreePriorityDispatchStrategy.class);

    @Override
    public Session select(String group, String topic, Set<Session> groupConsumerSessions) {
        if (CollectionUtils.isEmpty(groupConsumerSessions) || StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)group)) {
            return null;
        }
        ArrayList<Session> filtered = new ArrayList<Session>();
        ArrayList<Session> isolatedSessions = new ArrayList<Session>();
        for (Session session : groupConsumerSessions) {
            if (!session.isAvailable(topic)) continue;
            if (session.isIsolated()) {
                isolatedSessions.add(session);
                logger.info("session is not available because session is isolated,isolateTime:{},client:{}", (Object)session.getIsolateTime(), (Object)session.getClient());
                continue;
            }
            filtered.add(session);
        }
        if (CollectionUtils.isEmpty(filtered)) {
            if (CollectionUtils.isEmpty(isolatedSessions)) {
                logger.warn("all sessions can't downstream msg");
                return null;
            }
            logger.warn("all sessions are isolated,group:{},topic:{}", (Object)group, (Object)topic);
            filtered.addAll(isolatedSessions);
        }
        Collections.shuffle(filtered);
        Session session = (Session)filtered.get(0);
        return session;
    }
}

