/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.group;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.plugin.MQProducerWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.DownstreamDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.EventMeshTcpRetryer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.UpStreamMsgContext;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMonitor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.HttpTinyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientGroupWrapper {
    public static Logger logger = LoggerFactory.getLogger(ClientGroupWrapper.class);
    private String producerGroup;
    private String consumerGroup;
    private String sysId;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private EventMeshTCPServer eventMeshTCPServer;
    private EventMeshTcpRetryer eventMeshTcpRetryer;
    private EventMeshTcpMonitor eventMeshTcpMonitor;
    private DownstreamDispatchStrategy downstreamDispatchStrategy;
    private final ReadWriteLock groupLock = new ReentrantReadWriteLock();
    public Set<Session> groupConsumerSessions = new HashSet<Session>();
    public Set<Session> groupProducerSessions = new HashSet<Session>();
    public AtomicBoolean started4Persistent = new AtomicBoolean(Boolean.FALSE);
    public AtomicBoolean started4Broadcast = new AtomicBoolean(Boolean.FALSE);
    public AtomicBoolean inited4Persistent = new AtomicBoolean(Boolean.FALSE);
    public AtomicBoolean inited4Broadcast = new AtomicBoolean(Boolean.FALSE);
    private MQConsumerWrapper persistentMsgConsumer;
    private MQConsumerWrapper broadCastMsgConsumer;
    private ConcurrentHashMap<String, Set<Session>> topic2sessionInGroupMapping = new ConcurrentHashMap();
    public AtomicBoolean producerStarted = new AtomicBoolean(Boolean.FALSE);
    private MQProducerWrapper mqProducerWrapper;

    public ClientGroupWrapper(String sysId, String producerGroup, String consumerGroup, EventMeshTCPServer eventMeshTCPServer, DownstreamDispatchStrategy downstreamDispatchStrategy) {
        this.sysId = sysId;
        this.producerGroup = producerGroup;
        this.consumerGroup = consumerGroup;
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.eventMeshTCPConfiguration = eventMeshTCPServer.getEventMeshTCPConfiguration();
        this.eventMeshTcpRetryer = eventMeshTCPServer.getEventMeshTcpRetryer();
        this.eventMeshTcpMonitor = eventMeshTCPServer.getEventMeshTcpMonitor();
        this.downstreamDispatchStrategy = downstreamDispatchStrategy;
        this.persistentMsgConsumer = new MQConsumerWrapper(eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshConnectorPluginType);
        this.broadCastMsgConsumer = new MQConsumerWrapper(eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshConnectorPluginType);
        this.mqProducerWrapper = new MQProducerWrapper(eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshConnectorPluginType);
    }

    public ConcurrentHashMap<String, Set<Session>> getTopic2sessionInGroupMapping() {
        return this.topic2sessionInGroupMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscription(String topic) {
        boolean has = false;
        try {
            this.groupLock.readLock().lockInterruptibly();
            has = this.topic2sessionInGroupMapping.containsKey(topic);
        }
        catch (Exception e) {
            logger.error("hasSubscription error! topic[{}]", (Object)topic);
        }
        finally {
            this.groupLock.readLock().unlock();
        }
        return has;
    }

    public boolean send(UpStreamMsgContext upStreamMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.send(upStreamMsgContext.getEvent(), sendCallback);
        return true;
    }

    public void request(UpStreamMsgContext upStreamMsgContext, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.mqProducerWrapper.request(upStreamMsgContext.getEvent(), rrCallback, timeout);
    }

    public boolean reply(final UpStreamMsgContext upStreamMsgContext) throws Exception {
        this.mqProducerWrapper.reply(upStreamMsgContext.getEvent(), new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                String bizSeqNo = (String)upStreamMsgContext.getEvent().getExtension("keys");
                logger.error("reply err! topic:{}, bizSeqNo:{}, client:{}", new Object[]{upStreamMsgContext.getEvent().getSubject(), bizSeqNo, upStreamMsgContext.getSession().getClient(), context.getException()});
            }
        });
        return true;
    }

    public MQProducerWrapper getMqProducerWrapper() {
        return this.mqProducerWrapper;
    }

    public boolean addSubscription(String topic, Session session) throws Exception {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.consumerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getConsumerGroup()))) {
            logger.error("addSubscription param error,topic:{},session:{}", (Object)topic, (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            if (!this.topic2sessionInGroupMapping.containsKey(topic)) {
                HashSet sessions = new HashSet();
                this.topic2sessionInGroupMapping.put(topic, sessions);
            }
            if (r = this.topic2sessionInGroupMapping.get(topic).add(session)) {
                logger.info("addSubscription success, group:{} topic:{} client:{}", new Object[]{this.consumerGroup, topic, session.getClient()});
            } else {
                logger.warn("addSubscription fail, group:{} topic:{} client:{}", new Object[]{this.consumerGroup, topic, session.getClient()});
            }
        }
        catch (Exception e) {
            logger.error("addSubscription error! topic:{} client:{}", new Object[]{topic, session.getClient(), e});
            throw new Exception("addSubscription fail");
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscription(String topic, Session session) {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.consumerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getConsumerGroup()))) {
            logger.error("removeSubscription param error,topic:{},session:{}", (Object)topic, (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            if (this.topic2sessionInGroupMapping.containsKey(topic)) {
                r = this.topic2sessionInGroupMapping.get(topic).remove(session);
                if (r) {
                    logger.info("removeSubscription remove session success, group:{} topic:{} client:{}", new Object[]{this.consumerGroup, topic, session.getClient()});
                } else {
                    logger.warn("removeSubscription remove session failed, group:{} topic:{} client:{}", new Object[]{this.consumerGroup, topic, session.getClient()});
                }
            }
            if (CollectionUtils.size(this.topic2sessionInGroupMapping.get(topic)) == 0) {
                this.topic2sessionInGroupMapping.remove(topic);
                logger.info("removeSubscription remove topic success, group:{} topic:{}", (Object)this.consumerGroup, (Object)topic);
            }
        }
        catch (Exception e) {
            logger.error("removeSubscription error! topic:{} client:{}", new Object[]{topic, session.getClient(), e});
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    public synchronized void startClientGroupProducer() throws Exception {
        if (this.producerStarted.get()) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("producerGroup", this.producerGroup);
        keyValue.put("instanceName", EventMeshUtil.buildMeshTcpClientID(this.sysId, "PUB", this.eventMeshTCPConfiguration.eventMeshCluster));
        keyValue.put("eventMeshIDC", this.eventMeshTCPConfiguration.eventMeshIDC);
        this.mqProducerWrapper.init(keyValue);
        this.mqProducerWrapper.start();
        this.producerStarted.compareAndSet(false, true);
        logger.info("starting producer success, group:{}", (Object)this.producerGroup);
    }

    public synchronized void shutdownProducer() throws Exception {
        if (!this.producerStarted.get()) {
            return;
        }
        this.mqProducerWrapper.shutdown();
        this.producerStarted.compareAndSet(true, false);
        logger.info("shutdown producer success for group:{}", (Object)this.producerGroup);
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGroupConsumerSession(Session session) {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.consumerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getConsumerGroup()))) {
            logger.error("addGroupConsumerSession param error,session:{}", (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            r = this.groupConsumerSessions.add(session);
            if (r) {
                logger.info("addGroupConsumerSession success, group:{} client:{}", (Object)this.consumerGroup, (Object)session.getClient());
            }
        }
        catch (Exception e) {
            logger.error("addGroupConsumerSession error! group:{} client:{}", new Object[]{this.consumerGroup, session.getClient(), e});
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGroupProducerSession(Session session) {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.producerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getProducerGroup()))) {
            logger.error("addGroupProducerSession param error,session:{}", (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            r = this.groupProducerSessions.add(session);
            if (r) {
                logger.info("addGroupProducerSession success, group:{} client:{}", (Object)this.producerGroup, (Object)session.getClient());
            }
        }
        catch (Exception e) {
            logger.error("addGroupProducerSession error! group:{} client:{}", new Object[]{this.producerGroup, session.getClient(), e});
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGroupConsumerSession(Session session) {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.consumerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getConsumerGroup()))) {
            logger.error("removeGroupConsumerSession param error,session:{}", (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            r = this.groupConsumerSessions.remove(session);
            if (r) {
                logger.info("removeGroupConsumerSession success, group:{} client:{}", (Object)this.consumerGroup, (Object)session.getClient());
            }
        }
        catch (Exception e) {
            logger.error("removeGroupConsumerSession error! group:{} client:{}", new Object[]{this.consumerGroup, session.getClient(), e});
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGroupProducerSession(Session session) {
        if (session == null || !StringUtils.equalsIgnoreCase((CharSequence)this.producerGroup, (CharSequence)EventMeshUtil.buildClientGroup(session.getClient().getProducerGroup()))) {
            logger.error("removeGroupProducerSession param error,session:{}", (Object)session);
            return false;
        }
        boolean r = false;
        try {
            this.groupLock.writeLock().lockInterruptibly();
            r = this.groupProducerSessions.remove(session);
            if (r) {
                logger.info("removeGroupProducerSession success, group:{} client:{}", (Object)this.producerGroup, (Object)session.getClient());
            }
        }
        catch (Exception e) {
            logger.error("removeGroupProducerSession error! group:{} client:{}", new Object[]{this.producerGroup, session.getClient(), e});
        }
        finally {
            this.groupLock.writeLock().unlock();
        }
        return r;
    }

    public synchronized void initClientGroupPersistentConsumer() throws Exception {
        if (this.inited4Persistent.get()) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroup);
        keyValue.put("eventMeshIDC", this.eventMeshTCPConfiguration.eventMeshIDC);
        keyValue.put("instanceName", EventMeshUtil.buildMeshTcpClientID(this.sysId, "SUB", this.eventMeshTCPConfiguration.eventMeshCluster));
        this.persistentMsgConsumer.init(keyValue);
        this.inited4Persistent.compareAndSet(false, true);
        logger.info("init persistentMsgConsumer success, group:{}", (Object)this.consumerGroup);
    }

    public synchronized void startClientGroupPersistentConsumer() throws Exception {
        if (this.started4Persistent.get()) {
            return;
        }
        this.persistentMsgConsumer.start();
        this.started4Persistent.compareAndSet(false, true);
        logger.info("starting persistentMsgConsumer success, group:{}", (Object)this.consumerGroup);
    }

    public synchronized void initClientGroupBroadcastConsumer() throws Exception {
        if (this.inited4Broadcast.get()) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "true");
        keyValue.put("consumerGroup", this.consumerGroup);
        keyValue.put("eventMeshIDC", this.eventMeshTCPConfiguration.eventMeshIDC);
        keyValue.put("instanceName", EventMeshUtil.buildMeshTcpClientID(this.sysId, "SUB", this.eventMeshTCPConfiguration.eventMeshCluster));
        this.broadCastMsgConsumer.init(keyValue);
        this.inited4Broadcast.compareAndSet(false, true);
        logger.info("init broadCastMsgConsumer success, group:{}", (Object)this.consumerGroup);
    }

    public synchronized void startClientGroupBroadcastConsumer() throws Exception {
        if (this.started4Broadcast.get()) {
            return;
        }
        this.broadCastMsgConsumer.start();
        this.started4Broadcast.compareAndSet(false, true);
        logger.info("starting broadCastMsgConsumer success, group:{}", (Object)this.consumerGroup);
    }

    public void subscribe(final SubscriptionItem subscriptionItem) throws Exception {
        Object listener = null;
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionItem.getMode())) {
            listener = new EventListener(){

                public void consume(CloudEvent event, AsyncConsumeContext context) {
                    ClientGroupWrapper.this.eventMeshTcpMonitor.getMq2EventMeshMsgNum().incrementAndGet();
                    event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", ((ClientGroupWrapper)ClientGroupWrapper.this).eventMeshTCPConfiguration.eventMeshServerIp).build();
                    String topic = event.getSubject();
                    EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                    if (CollectionUtils.isEmpty(ClientGroupWrapper.this.groupConsumerSessions)) {
                        logger.warn("found no session to downstream broadcast msg");
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                        return;
                    }
                    Iterator<Session> sessionsItr = ClientGroupWrapper.this.groupConsumerSessions.iterator();
                    final DownStreamMsgContext downStreamMsgContext = new DownStreamMsgContext(event, null, ClientGroupWrapper.this.broadCastMsgConsumer, eventMeshAsyncConsumeContext.getAbstractContext(), false, subscriptionItem);
                    while (sessionsItr.hasNext()) {
                        final Session session = sessionsItr.next();
                        if (!session.isAvailable(topic)) {
                            logger.warn("downstream broadcast msg,session is not available,client:{}", (Object)session.getClient());
                            continue;
                        }
                        downStreamMsgContext.session = session;
                        ClientGroupWrapper.this.eventMeshTCPServer.getBroadcastMsgDownstreamExecutorService().submit(new Runnable(){

                            @Override
                            public void run() {
                                session.getPusher().unAckMsg(downStreamMsgContext.seq, downStreamMsgContext);
                                session.downstreamMsg(downStreamMsgContext);
                            }
                        });
                    }
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                }
            };
            this.broadCastMsgConsumer.subscribe(subscriptionItem.getTopic(), (EventListener)listener);
        } else {
            listener = new EventListener(){

                public void consume(CloudEvent event, AsyncConsumeContext context) {
                    ClientGroupWrapper.this.eventMeshTcpMonitor.getMq2EventMeshMsgNum().incrementAndGet();
                    event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", ((ClientGroupWrapper)ClientGroupWrapper.this).eventMeshTCPConfiguration.eventMeshServerIp).build();
                    String topic = event.getSubject();
                    EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                    Session session = ClientGroupWrapper.this.downstreamDispatchStrategy.select(ClientGroupWrapper.this.consumerGroup, topic, ClientGroupWrapper.this.groupConsumerSessions);
                    String bizSeqNo = EventMeshUtil.getMessageBizSeq(event);
                    if (session == null) {
                        try {
                            Integer sendBackTimes = new Integer(0);
                            String sendBackFromEventMeshIp = "";
                            if (StringUtils.isNotBlank((CharSequence)Objects.requireNonNull(event.getExtension("eventmeshdendbacktimes")).toString())) {
                                sendBackTimes = (Integer)event.getExtension("eventmeshdendbacktimes");
                            }
                            if (StringUtils.isNotBlank((CharSequence)Objects.requireNonNull(event.getExtension("eventmeshsendbackip")).toString())) {
                                sendBackFromEventMeshIp = (String)event.getExtension("eventmeshsendbackip");
                            }
                            logger.error("found no session to downstream msg,groupName:{}, topic:{}, bizSeqNo:{}, sendBackTimes:{}, sendBackFromEventMeshIp:{}", new Object[]{ClientGroupWrapper.this.consumerGroup, topic, bizSeqNo, sendBackTimes, sendBackFromEventMeshIp});
                            if (sendBackTimes >= ((ClientGroupWrapper)ClientGroupWrapper.this).eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpSendBackMaxTimes) {
                                logger.error("sendBack to broker over max times:{}, groupName:{}, topic:{}, bizSeqNo:{}", new Object[]{((ClientGroupWrapper)ClientGroupWrapper.this).eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpSendBackMaxTimes, ClientGroupWrapper.this.consumerGroup, topic, bizSeqNo});
                            } else {
                                Integer n = sendBackTimes;
                                Integer n2 = sendBackTimes = Integer.valueOf(sendBackTimes + 1);
                                event = CloudEventBuilder.from((CloudEvent)event).withExtension("eventmeshdendbacktimes", sendBackTimes.toString()).withExtension("eventmeshsendbackip", ((ClientGroupWrapper)ClientGroupWrapper.this).eventMeshTCPConfiguration.eventMeshServerIp).build();
                                ClientGroupWrapper.this.sendMsgBackToBroker(event, bizSeqNo);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("handle msg exception when no session found", (Throwable)e);
                        }
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                        return;
                    }
                    DownStreamMsgContext downStreamMsgContext = new DownStreamMsgContext(event, session, ClientGroupWrapper.this.persistentMsgConsumer, eventMeshAsyncConsumeContext.getAbstractContext(), false, subscriptionItem);
                    session.getPusher().unAckMsg(downStreamMsgContext.seq, downStreamMsgContext);
                    session.downstreamMsg(downStreamMsgContext);
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                }
            };
            this.persistentMsgConsumer.subscribe(subscriptionItem.getTopic(), (EventListener)listener);
        }
    }

    public void unsubscribe(SubscriptionItem subscriptionItem) throws Exception {
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionItem.getMode())) {
            this.broadCastMsgConsumer.unsubscribe(subscriptionItem.getTopic());
        } else {
            this.persistentMsgConsumer.unsubscribe(subscriptionItem.getTopic());
        }
    }

    public synchronized void shutdownBroadCastConsumer() throws Exception {
        if (this.started4Broadcast.get()) {
            this.broadCastMsgConsumer.shutdown();
            logger.info("broadcast consumer group:{} shutdown...", (Object)this.consumerGroup);
        }
        this.started4Broadcast.compareAndSet(true, false);
        this.inited4Broadcast.compareAndSet(true, false);
        this.broadCastMsgConsumer = null;
    }

    public synchronized void shutdownPersistentConsumer() throws Exception {
        if (this.started4Persistent.get()) {
            this.persistentMsgConsumer.shutdown();
            logger.info("persistent consumer group:{} shutdown...", (Object)this.consumerGroup);
        }
        this.started4Persistent.compareAndSet(true, false);
        this.inited4Persistent.compareAndSet(true, false);
        this.persistentMsgConsumer = null;
    }

    public Set<Session> getGroupConsumerSessions() {
        return this.groupConsumerSessions;
    }

    public Set<Session> getGroupProducerSessions() {
        return this.groupProducerSessions;
    }

    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    public void setEventMeshTCPConfiguration(EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    public EventMeshTcpRetryer getEventMeshTcpRetryer() {
        return this.eventMeshTcpRetryer;
    }

    public void setEventMeshTcpRetryer(EventMeshTcpRetryer eventMeshTcpRetryer) {
        this.eventMeshTcpRetryer = eventMeshTcpRetryer;
    }

    public EventMeshTcpMonitor getEventMeshTcpMonitor() {
        return this.eventMeshTcpMonitor;
    }

    public void setEventMeshTcpMonitor(EventMeshTcpMonitor eventMeshTcpMonitor) {
        this.eventMeshTcpMonitor = eventMeshTcpMonitor;
    }

    public DownstreamDispatchStrategy getDownstreamDispatchStrategy() {
        return this.downstreamDispatchStrategy;
    }

    public void setDownstreamDispatchStrategy(DownstreamDispatchStrategy downstreamDispatchStrategy) {
        this.downstreamDispatchStrategy = downstreamDispatchStrategy;
    }

    public String getSysId() {
        return this.sysId;
    }

    private String pushMsgToEventMesh(CloudEvent msg, String ip, int port) throws Exception {
        StringBuilder targetUrl = new StringBuilder();
        targetUrl.append("http://").append(ip).append(":").append(port).append("/eventMesh/msg/push");
        HttpTinyClient.HttpResult result = null;
        try {
            logger.info("pushMsgToEventMesh,targetUrl:{},msg:{}", (Object)targetUrl.toString(), (Object)msg);
            ArrayList<String> paramValues = new ArrayList<String>();
            paramValues.add("msg");
            paramValues.add(JsonUtils.serialize((Object)msg));
            paramValues.add("group");
            paramValues.add(this.consumerGroup);
            result = HttpTinyClient.httpPost(targetUrl.toString(), null, paramValues, "UTF-8", 3000L);
        }
        catch (Exception e) {
            logger.error("httpPost " + targetUrl + " is fail,", (Throwable)e);
            throw e;
        }
        if (200 == result.code && result.content != null) {
            return result.content;
        }
        throw new Exception("httpPost targetUrl[" + targetUrl + "] is not OK when getContentThroughHttp, httpResult: " + result + ".");
    }

    public MQConsumerWrapper getPersistentMsgConsumer() {
        return this.persistentMsgConsumer;
    }

    private void sendMsgBackToBroker(CloudEvent event, final String bizSeqNo) throws Exception {
        try {
            long startTime;
            final String topic = event.getSubject();
            logger.warn("send msg back to broker, bizSeqno:{}, topic:{}", (Object)bizSeqNo, (Object)topic);
            long taskExcuteTime = startTime = System.currentTimeMillis();
            this.send(new UpStreamMsgContext(null, event, null, startTime, taskExcuteTime), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    logger.info("consumerGroup:{} consume fail, sendMessageBack success, bizSeqno:{}, topic:{}", new Object[]{ClientGroupWrapper.this.consumerGroup, bizSeqNo, topic});
                }

                public void onException(OnExceptionContext context) {
                    logger.warn("consumerGroup:{} consume fail, sendMessageBack fail, bizSeqno:{}, topic:{}", new Object[]{ClientGroupWrapper.this.consumerGroup, bizSeqNo, topic});
                }
            });
            this.eventMeshTcpMonitor.getEventMesh2mqMsgNum().incrementAndGet();
        }
        catch (Exception e) {
            logger.warn("try send msg back to broker failed");
            throw e;
        }
    }
}

