/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.retry;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.runtime.core.protocol.http.retry.DelayRetryable;

public abstract class RetryContext
implements DelayRetryable {
    public int retryTimes = 0;
    public long executeTime = System.currentTimeMillis();

    public RetryContext delay(long delay) {
        this.executeTime = System.currentTimeMillis() + delay;
        return this;
    }

    @Override
    public int compareTo(Delayed delayed) {
        RetryContext obj = (RetryContext)delayed;
        if (this.executeTime > obj.executeTime) {
            return 1;
        }
        if (this.executeTime == obj.executeTime) {
            return 0;
        }
        return -1;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.executeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

