/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.retry.DelayRetryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRetryer {
    private Logger retryLogger = LoggerFactory.getLogger((String)"retry");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventMeshHTTPServer eventMeshHTTPServer;
    private DelayQueue<DelayRetryable> failed = new DelayQueue();
    private ThreadPoolExecutor pool;
    private Thread dispatcher;

    public HttpRetryer(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void pushRetry(DelayRetryable delayRetryable) {
        if (this.failed.size() >= this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerRetryBlockQSize) {
            this.retryLogger.error("[RETRY-QUEUE] is full!");
            return;
        }
        this.failed.offer(delayRetryable);
    }

    public void init() {
        this.pool = new ThreadPoolExecutor(this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerRetryThreadNum, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerRetryThreadNum, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerRetryBlockQSize), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "http-retry-" + this.count.incrementAndGet());
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        this.dispatcher = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DelayRetryable retryObj = null;
                    while (!Thread.currentThread().isInterrupted() && (retryObj = (DelayRetryable)HttpRetryer.this.failed.take()) != null) {
                        DelayRetryable delayRetryable = retryObj;
                        HttpRetryer.this.pool.execute(() -> {
                            try {
                                delayRetryable.retry();
                                if (HttpRetryer.this.retryLogger.isDebugEnabled()) {
                                    HttpRetryer.this.retryLogger.debug("retryObj : {}", (Object)delayRetryable);
                                }
                            }
                            catch (Exception e) {
                                HttpRetryer.this.retryLogger.error("http-retry-dispatcher error!", (Throwable)e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    HttpRetryer.this.retryLogger.error("http-retry-dispatcher error!", (Throwable)e);
                }
            }
        }, "http-retry-dispatcher");
        this.dispatcher.setDaemon(true);
        this.logger.info("HttpRetryer inited......");
    }

    public int size() {
        return this.failed.size();
    }

    public void shutdown() {
        this.dispatcher.interrupt();
        this.pool.shutdown();
        this.logger.info("HttpRetryer shutdown......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        this.logger.info("HttpRetryer started......");
    }
}

