/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPMessageHandler;
import org.apache.eventmesh.runtime.core.protocol.http.push.MessageHandler;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private EventMeshHTTPServer eventMeshHTTPServer;
    private AtomicBoolean started4Persistent = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean started4Broadcast = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean inited4Persistent = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean inited4Broadcast = new AtomicBoolean(Boolean.FALSE);
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private ConsumerGroupConf consumerGroupConf;
    private MQConsumerWrapper persistentMqConsumer;
    private MQConsumerWrapper broadcastMqConsumer;
    private MessageHandler httpMessageHandler;

    public EventMeshConsumer(EventMeshHTTPServer eventMeshHTTPServer, ConsumerGroupConf consumerGroupConf) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.consumerGroupConf = consumerGroupConf;
        this.persistentMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshConnectorPluginType);
        this.broadcastMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshConnectorPluginType);
    }

    public synchronized void init() throws Exception {
        this.httpMessageHandler = new HTTPMessageHandler(this);
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        keyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster));
        this.persistentMqConsumer.init(keyValue);
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        this.inited4Persistent.compareAndSet(false, true);
        this.inited4Broadcast.compareAndSet(false, true);
        this.logger.info("EventMeshConsumer [{}] inited.............", (Object)this.consumerGroupConf.getConsumerGroup());
    }

    public synchronized void start() throws Exception {
        this.persistentMqConsumer.start();
        this.started4Persistent.compareAndSet(false, true);
        this.broadcastMqConsumer.start();
        this.started4Broadcast.compareAndSet(false, true);
    }

    public void subscribe(String topic, final SubscriptionItem subscriptionItem) throws Exception {
        Object listener = null;
        if (!SubscriptionMode.BROADCASTING.equals((Object)subscriptionItem.getMode())) {
            listener = new EventListener(){

                public void consume(CloudEvent event, AsyncConsumeContext context) {
                    String topic = event.getSubject();
                    String bizSeqNo = (String)event.getExtension("searchkeys");
                    String uniqueId = (String)event.getExtension("rmbuniqid");
                    event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
                    if (EventMeshConsumer.this.messageLogger.isDebugEnabled()) {
                        EventMeshConsumer.this.messageLogger.debug("message|mq2eventMesh|topic={}|event={}", (Object)topic, (Object)event);
                    } else {
                        EventMeshConsumer.this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                    }
                    ConsumerGroupTopicConf currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(EventMeshConsumer.this.consumerGroupConf.getConsumerGroupTopicConf(), (Object)topic, null);
                    EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                    if (currentTopicConfig == null) {
                        EventMeshConsumer.this.logger.error("no topicConfig found, consumerGroup:{} topic:{}", (Object)EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), (Object)topic);
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    HandleMsgContext handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), EventMeshConsumer.this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), EventMeshConsumer.this.consumerGroupConf, EventMeshConsumer.this.eventMeshHTTPServer, bizSeqNo, uniqueId, currentTopicConfig);
                    if (EventMeshConsumer.this.httpMessageHandler.handle(handleMsgContext)) {
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                    } else {
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                    }
                }
            };
            this.persistentMqConsumer.subscribe(topic, (EventListener)listener);
        } else {
            listener = new EventListener(){

                public void consume(CloudEvent event, AsyncConsumeContext context) {
                    event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
                    String topic = event.getSubject();
                    String bizSeqNo = event.getExtension("searchkeys").toString();
                    String uniqueId = event.getExtension("rmbuniqid").toString();
                    if (EventMeshConsumer.this.messageLogger.isDebugEnabled()) {
                        EventMeshConsumer.this.messageLogger.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
                    } else {
                        EventMeshConsumer.this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                    }
                    ConsumerGroupTopicConf currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(EventMeshConsumer.this.consumerGroupConf.getConsumerGroupTopicConf(), (Object)topic, null);
                    EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                    if (currentTopicConfig == null) {
                        EventMeshConsumer.this.logger.error("no topicConfig found, consumerGroup:{} topic:{}", (Object)EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), (Object)topic);
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    HandleMsgContext handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), EventMeshConsumer.this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), EventMeshConsumer.this.consumerGroupConf, EventMeshConsumer.this.eventMeshHTTPServer, bizSeqNo, uniqueId, currentTopicConfig);
                    if (EventMeshConsumer.this.httpMessageHandler.handle(handleMsgContext)) {
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                    } else {
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                    }
                }
            };
            this.broadcastMqConsumer.subscribe(topic, (EventListener)listener);
        }
    }

    public void unsubscribe(String topic, SubscriptionMode subscriptionMode) throws Exception {
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.unsubscribe(topic);
        } else {
            this.persistentMqConsumer.unsubscribe(topic);
        }
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.started4Persistent.compareAndSet(true, false);
        this.broadcastMqConsumer.shutdown();
        this.started4Broadcast.compareAndSet(true, false);
    }

    public void updateOffset(String topic, SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) {
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.updateOffset(events, context);
        } else {
            this.persistentMqConsumer.updateOffset(events, context);
        }
    }

    public ConsumerGroupConf getConsumerGroupConf() {
        return this.consumerGroupConf;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public void sendMessageBack(CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer sendMessageBack = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(this.consumerGroupConf.getConsumerGroup());
        if (sendMessageBack == null) {
            this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, sendMessageBack, this.eventMeshHTTPServer);
        sendMessageBack.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                EventMeshConsumer.this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqno:{}, uniqueId:{}", new Object[]{EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            }
        });
    }
}

