/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;

public class EventMeshTCPConfiguration
extends CommonConfiguration {
    public int eventMeshTcpServerPort = 10000;
    public int eventMeshTcpIdleAllSeconds = 60;
    public int eventMeshTcpIdleWriteSeconds = 60;
    public int eventMeshTcpIdleReadSeconds = 60;
    public Integer eventMeshTcpMsgReqnumPerSecond = 15000;
    public int eventMeshTcpClientMaxNum = 10000;
    public boolean eventMeshTcpServerEnabled = Boolean.FALSE;
    public int eventMeshTcpGlobalScheduler = 5;
    public int eventMeshTcpTaskHandleExecutorPoolSize = Runtime.getRuntime().availableProcessors();
    public int eventMeshTcpMsgDownStreamExecutorPoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 8);
    public int eventMeshTcpSessionExpiredInMills = 60000;
    public int eventMeshTcpSessionUpstreamBufferSize = 100;
    public int eventMeshTcpMsgAsyncRetryTimes = 3;
    public int eventMeshTcpMsgSyncRetryTimes = 1;
    public int eventMeshTcpMsgRetrySyncDelayInMills = 500;
    public int eventMeshTcpMsgRetryAsyncDelayInMills = 500;
    public int eventMeshTcpMsgRetryQueueSize = 10000;
    public Integer eventMeshTcpRebalanceIntervalInMills = 30000;
    public int eventMeshServerAdminPort = 10106;
    public boolean eventMeshTcpSendBackEnabled = Boolean.TRUE;
    public int eventMeshTcpSendBackMaxTimes = 3;
    public int eventMeshTcpPushFailIsolateTimeInMills = 30000;
    public int gracefulShutdownSleepIntervalInMills = 1000;
    public int sleepIntervalInRebalanceRedirectMills = 200;
    private TrafficShapingConfig gtc = new TrafficShapingConfig(0L, 10000L, 1000L, 2000L);
    private TrafficShapingConfig ctc = new TrafficShapingConfig(0L, 2000L, 1000L, 10000L);

    public EventMeshTCPConfiguration(ConfigurationWrapper configurationWrapper) {
        super(configurationWrapper);
    }

    public void init() {
        super.init();
        this.eventMeshTcpServerPort = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_PORT, this.eventMeshTcpServerPort);
        this.eventMeshTcpIdleReadSeconds = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS, this.eventMeshTcpIdleReadSeconds);
        this.eventMeshTcpIdleWriteSeconds = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS, this.eventMeshTcpIdleWriteSeconds);
        this.eventMeshTcpIdleAllSeconds = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS, this.eventMeshTcpIdleAllSeconds);
        this.eventMeshTcpMsgReqnumPerSecond = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS, this.eventMeshTcpMsgReqnumPerSecond.intValue());
        this.eventMeshTcpClientMaxNum = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM, this.eventMeshTcpClientMaxNum);
        this.eventMeshTcpServerEnabled = this.configurationWrapper.getBoolProp(ConfKeys.KEYS_EVENTMESH_TCP_SERVER_ENABLED, this.eventMeshTcpServerEnabled);
        this.eventMeshTcpGlobalScheduler = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER, this.eventMeshTcpGlobalScheduler);
        this.eventMeshTcpTaskHandleExecutorPoolSize = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE, this.eventMeshTcpTaskHandleExecutorPoolSize);
        this.eventMeshTcpMsgDownStreamExecutorPoolSize = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE, this.eventMeshTcpMsgDownStreamExecutorPoolSize);
        this.eventMeshTcpSessionExpiredInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME, this.eventMeshTcpSessionExpiredInMills);
        this.eventMeshTcpSessionUpstreamBufferSize = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE, this.eventMeshTcpSessionUpstreamBufferSize);
        this.eventMeshTcpMsgAsyncRetryTimes = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_TIMES, this.eventMeshTcpMsgAsyncRetryTimes);
        this.eventMeshTcpMsgSyncRetryTimes = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_TIMES, this.eventMeshTcpMsgSyncRetryTimes);
        this.eventMeshTcpMsgRetryAsyncDelayInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_DELAY, this.eventMeshTcpMsgRetryAsyncDelayInMills);
        this.eventMeshTcpMsgRetrySyncDelayInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_DELAY, this.eventMeshTcpMsgRetrySyncDelayInMills);
        this.eventMeshTcpMsgRetryQueueSize = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE, this.eventMeshTcpMsgRetryQueueSize);
        this.eventMeshTcpRebalanceIntervalInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL, this.eventMeshTcpRebalanceIntervalInMills.intValue());
        this.eventMeshServerAdminPort = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT, this.eventMeshServerAdminPort);
        this.eventMeshTcpSendBackEnabled = this.configurationWrapper.getBoolProp(ConfKeys.KEYS_EVENTMESH_TCP_SEND_BACK_ENABLED, this.eventMeshTcpSendBackEnabled);
        this.eventMeshTcpPushFailIsolateTimeInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME, this.eventMeshTcpPushFailIsolateTimeInMills);
        this.gracefulShutdownSleepIntervalInMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_GRACEFUL_SHUTDOWN_SLEEP_TIME, this.gracefulShutdownSleepIntervalInMills);
        this.sleepIntervalInRebalanceRedirectMills = this.configurationWrapper.getIntProp(ConfKeys.KEYS_EVENTMESH_SERVER_REBALANCE_REDIRECT_SLEEP_TIME, this.sleepIntervalInRebalanceRedirectMills);
    }

    public TrafficShapingConfig getGtc() {
        return this.gtc;
    }

    public TrafficShapingConfig getCtc() {
        return this.ctc;
    }

    public static class TrafficShapingConfig {
        long writeLimit = 0L;
        long readLimit = 1000L;
        long checkInterval = 1000L;
        long maxTime = 5000L;

        public TrafficShapingConfig(long writeLimit, long readLimit, long checkInterval, long maxTime) {
            this.writeLimit = writeLimit;
            this.readLimit = readLimit;
            this.checkInterval = checkInterval;
            this.maxTime = maxTime;
        }

        public TrafficShapingConfig() {
        }

        public long getWriteLimit() {
            return this.writeLimit;
        }

        public void setWriteLimit(long writeLimit) {
            this.writeLimit = writeLimit;
        }

        public long getReadLimit() {
            return this.readLimit;
        }

        public void setReadLimit(long readLimit) {
            this.readLimit = readLimit;
        }

        public long getCheckInterval() {
            return this.checkInterval;
        }

        public void setCheckInterval(long checkInterval) {
            this.checkInterval = checkInterval;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        public String toString() {
            return "TrafficShapingConfig{writeLimit=" + this.writeLimit + ", readLimit=" + this.readLimit + ", checkInterval=" + this.checkInterval + ", maxTime=" + this.maxTime + '}';
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_SERVER_TCP_PORT = "eventMesh.server.tcp.port";
        public static String KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS = "eventMesh.server.tcp.readerIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS = "eventMesh.server.tcp.writerIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS = "eventMesh.server.tcp.allIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM = "eventMesh.server.tcp.clientMaxNum";
        public static String KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS = "eventMesh.server.tcp.msgReqnumPerSecond";
        public static String KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL = "eventMesh.server.tcp.RebalanceIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER = "eventMesh.server.global.scheduler";
        public static String KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE = "eventMesh.server.tcp.taskHandleExecutorPoolSize";
        public static String KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE = "eventMesh.server.tcp.msgDownStreamExecutorPoolSize";
        public static String KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME = "eventMesh.server.session.expiredInMills";
        public static String KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE = "eventMesh.server.session.upstreamBufferSize";
        public static String KEYS_EVENTMESH_SERVER_SESSION_DOWNSTREAM_UNACK_SIZE = "eventMesh.server.session.downstreamUnackSize";
        public static String KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_TIMES = "eventMesh.server.retry.async.pushRetryTimes";
        public static String KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_TIMES = "eventMesh.server.retry.sync.pushRetryTimes";
        public static String KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_DELAY = "eventMesh.server.retry.async.pushRetryDelayInMills";
        public static String KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_DELAY = "eventMesh.server.retry.sync.pushRetryDelayInMills";
        public static String KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE = "eventMesh.server.retry.pushRetryQueueSize";
        public static String KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT = "eventMesh.server.admin.http.port";
        public static String KEYS_EVENTMESH_TCP_SERVER_ENABLED = "eventMesh.server.tcp.enabled";
        public static String KEYS_EVENTMESH_TCP_SEND_BACK_ENABLED = "eventMesh.server.tcp.sendBack.enabled";
        public static String KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME = "eventMesh.server.tcp.pushFailIsolateTimeInMills";
        public static String KEYS_EVENTMESH_SERVER_GRACEFUL_SHUTDOWN_SLEEP_TIME = "eventMesh.server.gracefulShutdown.sleepIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_REBALANCE_REDIRECT_SLEEP_TIME = "eventMesh.server.rebalanceRedirect.sleepIntervalInM";

        ConfKeys() {
        }
    }
}

