/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemotingServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public EventLoopGroup bossGroup;
    public EventLoopGroup ioGroup;
    public EventLoopGroup workerGroup;
    public int port;

    private EventLoopGroup initBossGroup(final String threadPrefix) {
        this.bossGroup = new NioEventLoopGroup(1, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadPrefix + "-boss-" + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        return this.bossGroup;
    }

    private EventLoopGroup initIOGroup(final String threadPrefix) {
        this.ioGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadPrefix + "-io-" + this.count.incrementAndGet());
                return t;
            }
        });
        return this.ioGroup;
    }

    private EventLoopGroup initWorkerGroup(final String threadPrefix) {
        this.workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadPrefix + "-worker-" + this.count.incrementAndGet());
                return t;
            }
        });
        return this.workerGroup;
    }

    public void init(String threadPrefix) throws Exception {
        this.initBossGroup(threadPrefix);
        this.initIOGroup(threadPrefix);
        this.initWorkerGroup(threadPrefix);
    }

    public void shutdown() throws Exception {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.logger.info("shutdown bossGroup");
        }
        ThreadUtils.randomSleep((int)30);
        if (this.ioGroup != null) {
            this.ioGroup.shutdownGracefully();
            this.logger.info("shutdown ioGroup");
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.logger.info("shutdown workerGroup");
        }
    }

    public void start() throws Exception {
    }
}

