/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectClientByIpPortHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RejectClientByIpPortHandler.class);
    private EventMeshTCPServer eventMeshTCPServer;

    public RejectClientByIpPortHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            String queryString = httpExchange.getRequestURI().getQuery();
            Map<String, String> queryStringInfo = NetUtils.formData2Dic(queryString);
            String ip = queryStringInfo.get("ip");
            String port = queryStringInfo.get("port");
            if (StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)port)) {
                httpExchange.sendResponseHeaders(200, 0L);
                result = "params illegal!";
                out.write(result.getBytes());
                return;
            }
            logger.info("rejectClientByIpPort in admin,ip:{},port:{}====================", (Object)ip, (Object)port);
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
            try {
                if (!sessionMap.isEmpty()) {
                    for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                        InetSocketAddress addr;
                        if (!entry.getKey().getHostString().equals(ip) || !String.valueOf(entry.getKey().getPort()).equals(port) || (addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, entry.getValue(), clientSessionGroupMapping)) == null) continue;
                        successRemoteAddrs.add(addr);
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientManage|rejectClientByIpPort|fail|ip={}|port={},errMsg={}", new Object[]{ip, port, e});
                result = String.format("rejectClientByIpPort fail! {ip=%s port=%s}, had reject {%s}, errorMsg : %s", ip, port, NetUtils.addressToString(successRemoteAddrs), e.getMessage());
                httpExchange.sendResponseHeaders(200, 0L);
                out.write(result.getBytes());
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        logger.warn("out close failed...", (Throwable)e2);
                    }
                }
                return;
            }
            result = String.format("rejectClientByIpPort success! {ip=%s port=%s}, had reject {%s}", ip, port, NetUtils.addressToString(successRemoteAddrs));
            httpExchange.sendResponseHeaders(200, 0L);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            logger.error("rejectClientByIpPort fail...", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

