## How to run eventmesh-sdk-java demo

> Eventmesh-sdk-java , as the client, communicated with eventmesh-runtime, used to complete the sending and receiving of message.
>
> Eventmesh-sdk-java supports async msg and broadcast msg. Async msg means the producer just sends msg and does not care reply msg.Broadcast msg means the producer send msg once and all the consumer subscribed the broadcast topic will receive the msg.
>
> Eventmesh-sdk-java supports  the protocol  of HTTP and TCP.

TCP demos and Http demos are both under the **eventmesh-test** module.

**prerequisite**：after download the source code you should copy `/conf/application.properties` and `/conf/log4j2.xml` to
the `resources` directory

![image-test-structure](../../images/eventmesh-test-structure.png)

### 1. TCP DEMO

#### Async msg

- create topic TEST-TOPIC-TCP-ASYNC on rocketmq-console

- start consumer ,subscribe topic in previous step.

```
Run the main method of org.apache.eventmesh.tcp.demo.AsyncSubscribe
```

- start producer, send message

```
Run the main method of org.apache.eventmesh.tcp.demo.AsyncPublish
```

#### Broadcast msg

- create topic TEST-TOPIC-TCP-BROADCAST on rocketmq-console

- start consumer ,subscribe topic in previous step.

```
Run the main method of org.apache.eventmesh.tcp.demo.AsyncSubscribeBroadcast
```

* start producer, send broadcast message

```
Run the main method of org.apache.eventmesh.tcp.demo.AsyncPublishBroadcast
```

### 2. HTTP DEMO

> As to http, eventmesh-sdk-java implements  the pub and sub for async event .
>
> In the demo ,the field of `content` of the java class `LiteMessage` represents a special protocal, so if you want to use http-client of eventmesh-sdk-java, you just need to design the content of protocal and supply the consumer appliacation at the same time.

#### Async event

> producer send the event to consumer and don't need waiting response msg from consumer

- create topic TEST-TOPIC-HTTP-ASYNC on rocketmq-console

- start consumer, subscribe topic

  Async consumer demo is a spring boot application demo, you can easily run this demo to start service and subscribe the
  topic.

```
Run the main method of org.apache.eventmesh.http.demo.sub.SpringBootDemoApplication
```

- start producer, produce msg

```
Run the main method of org.apache.eventmesh.http.demo.AsyncPublishInstance
```

