/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.tcp.SimpleSubClient;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.common.TcpClient;
import org.apache.eventmesh.common.protocol.SubcriptionType;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubClientImpl
extends TcpClient
implements SimpleSubClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserAgent userAgent;
    private ReceiveMsgHook callback;
    private List<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
    private ScheduledFuture<?> task;

    public SimpleSubClientImpl(String accessIp, int port, UserAgent agent) {
        super(accessIp, port);
        this.userAgent = agent;
    }

    @Override
    public void registerBusiHandler(ReceiveMsgHook handler) throws Exception {
        this.callback = handler;
    }

    @Override
    public void init() throws Exception {
        this.open(new Handler());
        this.hello();
        this.logger.info("SimpleSubClientImpl|{}|started!", (Object)this.clientNo);
    }

    @Override
    public void reconnect() throws Exception {
        super.reconnect();
        this.hello();
        if (!CollectionUtils.isEmpty(this.subscriptionItems)) {
            for (SubscriptionItem item : this.subscriptionItems) {
                Package request = MessageUtils.subscribe(item.getTopic(), item.getMode(), item.getType());
                this.io(request, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
            }
        }
        this.listen();
    }

    @Override
    public void close() {
        try {
            this.task.cancel(false);
            this.goodbye();
            super.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void heartbeat() throws Exception {
        this.task = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SimpleSubClientImpl.this.isActive()) {
                        SimpleSubClientImpl.this.reconnect();
                    }
                    Package msg = MessageUtils.heartBeat();
                    SimpleSubClientImpl.this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, EventMeshCommon.HEATBEAT, EventMeshCommon.HEATBEAT, TimeUnit.MILLISECONDS);
    }

    private void goodbye() throws Exception {
        Package msg = MessageUtils.goodbye();
        this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    private void hello() throws Exception {
        Package msg = MessageUtils.hello(this.userAgent);
        this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    @Override
    public void listen() throws Exception {
        Package request = MessageUtils.listen();
        this.io(request, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubcriptionType subcriptionType) throws Exception {
        this.subscriptionItems.add(new SubscriptionItem(topic, subscriptionMode, subcriptionType));
        Package request = MessageUtils.subscribe(topic, subscriptionMode, subcriptionType);
        this.io(request, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    @Override
    public void unsubscribe() throws Exception {
        Package request = MessageUtils.unsubscribe();
        this.io(request, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    @Override
    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public String toString() {
        return "SimpleSubClientImpl|clientNo=" + this.clientNo + "|" + this.userAgent;
    }

    @ChannelHandler.Sharable
    private class Handler
    extends SimpleChannelInboundHandler<Package> {
        private Handler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Package msg) throws Exception {
            Package pkg;
            Command cmd = msg.getHeader().getCommand();
            SimpleSubClientImpl.this.logger.info(SimpleSubClientImpl.class.getSimpleName() + "|receive|type={}|msg={}", (Object)cmd, (Object)msg);
            if (cmd == Command.REQUEST_TO_CLIENT) {
                if (SimpleSubClientImpl.this.callback != null) {
                    SimpleSubClientImpl.this.callback.handle(msg, ctx);
                }
                pkg = MessageUtils.requestToClientAck(msg);
                SimpleSubClientImpl.this.send(pkg);
            } else if (cmd == Command.ASYNC_MESSAGE_TO_CLIENT) {
                pkg = MessageUtils.asyncMessageAck(msg);
                if (SimpleSubClientImpl.this.callback != null) {
                    SimpleSubClientImpl.this.callback.handle(msg, ctx);
                }
                SimpleSubClientImpl.this.send(pkg);
            } else if (cmd == Command.BROADCAST_MESSAGE_TO_CLIENT) {
                pkg = MessageUtils.broadcastMessageAck(msg);
                if (SimpleSubClientImpl.this.callback != null) {
                    SimpleSubClientImpl.this.callback.handle(msg, ctx);
                }
                SimpleSubClientImpl.this.send(pkg);
            } else if (cmd != Command.SERVER_GOODBYE_REQUEST) {
                SimpleSubClientImpl.this.logger.error("msg ignored|{}|{}", (Object)cmd, (Object)msg);
            }
            RequestContext context = (RequestContext)SimpleSubClientImpl.this.contexts.get(RequestContext._key(msg));
            if (context != null) {
                SimpleSubClientImpl.this.contexts.remove(context.getKey());
                context.finish(msg);
                return;
            }
            SimpleSubClientImpl.this.logger.error("msg ignored,context not found.|{}|{}", (Object)cmd, (Object)msg);
        }
    }
}

