/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.client.tcp.SimplePubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.common.TcpClient;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePubClientImpl
extends TcpClient
implements SimplePubClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserAgent userAgent;
    private ReceiveMsgHook callback;
    private ConcurrentHashMap<String, AsyncRRCallback> callbackConcurrentHashMap = new ConcurrentHashMap();
    private ScheduledFuture<?> task;

    public SimplePubClientImpl(String accessIp, int port, UserAgent agent) {
        super(accessIp, port);
        this.userAgent = agent;
    }

    @Override
    public void registerBusiHandler(ReceiveMsgHook handler) throws Exception {
        this.callback = handler;
    }

    @Override
    public void init() throws Exception {
        this.open(new Handler());
        this.hello();
        this.logger.info("SimplePubClientImpl|{}|started!", (Object)this.clientNo);
    }

    @Override
    public void reconnect() throws Exception {
        super.reconnect();
        this.hello();
    }

    @Override
    public void close() {
        try {
            this.task.cancel(false);
            this.goodbye();
            super.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void heartbeat() throws Exception {
        this.task = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SimplePubClientImpl.this.isActive()) {
                        SimplePubClientImpl.this.reconnect();
                    }
                    Package msg = MessageUtils.heartBeat();
                    SimplePubClientImpl.this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, EventMeshCommon.HEATBEAT, EventMeshCommon.HEATBEAT, TimeUnit.MILLISECONDS);
    }

    private void goodbye() throws Exception {
        Package msg = MessageUtils.goodbye();
        this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    private void hello() throws Exception {
        Package msg = MessageUtils.hello(this.userAgent);
        this.io(msg, EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
    }

    @Override
    public Package rr(Package msg, long timeout) throws Exception {
        this.logger.info("SimplePubClientImpl|{}|rr|send|type={}|msg={}", new Object[]{this.clientNo, msg.getHeader().getCommand(), msg});
        return this.io(msg, timeout);
    }

    @Override
    public void asyncRR(Package msg, AsyncRRCallback callback, long timeout) throws Exception {
        super.send(msg);
        this.callbackConcurrentHashMap.put((String)RequestContext._key(msg), callback);
    }

    @Override
    public Package publish(Package msg, long timeout) throws Exception {
        this.logger.info("SimplePubClientImpl|{}|publish|send|type={}|msg={}", new Object[]{this.clientNo, msg.getHeader().getCommand(), msg});
        return this.io(msg, timeout);
    }

    @Override
    public void broadcast(Package msg, long timeout) throws Exception {
        this.logger.info("SimplePubClientImpl|{}|broadcast|send|type={}|msg={}", new Object[]{this.clientNo, msg.getHeader().getCommand(), msg});
        super.send(msg);
    }

    @Override
    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public String toString() {
        return "SimplePubClientImpl|clientNo=" + this.clientNo + "|" + this.userAgent;
    }

    @ChannelHandler.Sharable
    private class Handler
    extends SimpleChannelInboundHandler<Package> {
        private Handler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Package msg) throws Exception {
            SimplePubClientImpl.this.logger.info("SimplePubClientImpl|{}|receive|type={}|msg={}", new Object[]{SimplePubClientImpl.this.clientNo, msg.getHeader(), msg});
            Command cmd = msg.getHeader().getCommand();
            if (cmd == Command.RESPONSE_TO_CLIENT) {
                if (SimplePubClientImpl.this.callback != null) {
                    SimplePubClientImpl.this.callback.handle(msg, ctx);
                }
                Package pkg = MessageUtils.responseToClientAck(msg);
                SimplePubClientImpl.this.send(pkg);
            } else if (cmd == Command.SERVER_GOODBYE_REQUEST) {
                // empty if block
            }
            RequestContext context = (RequestContext)SimplePubClientImpl.this.contexts.get(RequestContext._key(msg));
            if (context != null) {
                SimplePubClientImpl.this.contexts.remove(context.getKey());
                context.finish(msg);
                return;
            }
        }
    }
}

