/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl;

import org.apache.eventmesh.client.tcp.EventMeshClient;
import org.apache.eventmesh.client.tcp.SimplePubClient;
import org.apache.eventmesh.client.tcp.SimpleSubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.impl.SimplePubClientImpl;
import org.apache.eventmesh.client.tcp.impl.SimpleSubClientImpl;
import org.apache.eventmesh.common.protocol.SubcriptionType;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;

public class DefaultEventMeshClient
implements EventMeshClient {
    protected UserAgent agent;
    private String accessHost;
    private int accessPort;
    private SimplePubClient pubClient;
    private SimpleSubClient subClient;

    public DefaultEventMeshClient(String accessHost, int accessPort, UserAgent agent) {
        this.accessHost = accessHost;
        this.accessPort = accessPort;
        this.agent = agent;
        UserAgent subAgent = MessageUtils.generateSubClient(agent);
        this.subClient = new SimpleSubClientImpl(accessHost, accessPort, subAgent);
        UserAgent pubAgent = MessageUtils.generatePubClient(agent);
        this.pubClient = new SimplePubClientImpl(accessHost, accessPort, pubAgent);
    }

    @Override
    public SimplePubClient getPubClient() {
        return this.pubClient;
    }

    public void setPubClient(SimplePubClient pubClient) {
        this.pubClient = pubClient;
    }

    @Override
    public SimpleSubClient getSubClient() {
        return this.subClient;
    }

    public void setSubClient(SimpleSubClient subClient) {
        this.subClient = subClient;
    }

    @Override
    public Package rr(Package msg, long timeout) throws Exception {
        return this.pubClient.rr(msg, timeout);
    }

    @Override
    public Package publish(Package msg, long timeout) throws Exception {
        return this.pubClient.publish(msg, timeout);
    }

    @Override
    public void broadcast(Package msg, long timeout) throws Exception {
        this.pubClient.broadcast(msg, timeout);
    }

    @Override
    public void init() throws Exception {
        this.subClient.init();
        this.pubClient.init();
    }

    @Override
    public void close() {
        this.pubClient.close();
        this.subClient.close();
    }

    @Override
    public void heartbeat() throws Exception {
        this.pubClient.heartbeat();
        this.subClient.heartbeat();
    }

    @Override
    public void listen() throws Exception {
        this.subClient.listen();
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubcriptionType subcriptionType) throws Exception {
        this.subClient.subscribe(topic, subscriptionMode, subcriptionType);
    }

    @Override
    public void unsubscribe() throws Exception {
        this.subClient.unsubscribe();
    }

    @Override
    public void registerSubBusiHandler(ReceiveMsgHook handler) throws Exception {
        this.subClient.registerBusiHandler(handler);
    }

    @Override
    public void asyncRR(Package msg, AsyncRRCallback callback, long timeout) throws Exception {
        this.pubClient.asyncRR(msg, callback, timeout);
    }

    @Override
    public void registerPubBusiHandler(ReceiveMsgHook handler) throws Exception {
        this.pubClient.registerBusiHandler(handler);
    }

    public String toString() {
        return "DefaultEventMeshClient{accessHost='" + this.accessHost + '\'' + ", accessPort=" + this.accessPort + ", agent=" + this.agent + '}';
    }
}

