/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.eventmesh.client.tcp.common.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.codec.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TcpClient
implements Closeable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public int clientNo = new Random().nextInt(1000);
    protected ConcurrentHashMap<Object, RequestContext> contexts = new ConcurrentHashMap();
    private final String host;
    private final int port;
    private Bootstrap bootstrap = new Bootstrap();
    private EventLoopGroup workers = new NioEventLoopGroup();
    private Channel channel;
    protected static final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4, new EventMeshThreadFactoryImpl("TCPClientScheduler", true));
    private ScheduledFuture<?> task;

    public TcpClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    protected synchronized void open(final SimpleChannelInboundHandler<Package> handler) throws Exception {
        this.bootstrap.group(this.workers);
        this.bootstrap.channel(NioSocketChannel.class);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)65536)).option(ChannelOption.SO_RCVBUF, (Object)65536)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 8192, 65536))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new Codec.Encoder(), new Codec.Decoder()}).addLast(new ChannelHandler[]{handler, TcpClient.this.newExceptionHandler()});
            }
        });
        ChannelFuture f = this.bootstrap.connect(this.host, this.port).sync();
        InetSocketAddress localAddress = (InetSocketAddress)f.channel().localAddress();
        this.channel = f.channel();
        this.logger.info("connected|local={}:{}|server={}", new Object[]{localAddress.getAddress().getHostAddress(), localAddress.getPort(), this.host + ":" + this.port});
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.disconnect().sync();
        }
        catch (InterruptedException e) {
            this.logger.warn("close tcp client failed.|remote address={}", (Object)this.channel.remoteAddress(), (Object)e);
        }
        this.workers.shutdownGracefully();
    }

    protected synchronized void reconnect() throws Exception {
        ChannelFuture f = this.bootstrap.connect(this.host, this.port).sync();
        this.channel = f.channel();
    }

    protected boolean isActive() {
        return this.channel != null && this.channel.isActive();
    }

    protected void send(Package msg) throws Exception {
        if (this.channel.isWritable()) {
            this.channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    this.logger.warn("send msg failed", (Object)future.isSuccess(), (Object)future.cause());
                }
            }));
        } else {
            this.channel.writeAndFlush((Object)msg).sync();
        }
    }

    protected Package io(Package msg, long timeout) throws Exception {
        CountDownLatch latch;
        Object key = RequestContext._key(msg);
        RequestContext c = RequestContext._context(key, msg, latch = new CountDownLatch(1));
        if (!this.contexts.contains(c)) {
            this.contexts.put(key, c);
        } else {
            this.logger.info("duplicate key : {}", key);
        }
        this.send(msg);
        if (!c.getLatch().await(timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("operation timeout, context.key=" + c.getKey());
        }
        return c.getResponse();
    }

    private ChannelDuplexHandler newExceptionHandler() {
        return new ChannelDuplexHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                TcpClient.this.logger.info("exceptionCaught, close connection.|remote address={}", (Object)ctx.channel().remoteAddress(), (Object)cause);
                ctx.close();
            }
        };
    }
}

