/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.common.protocol.SubcriptionType;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;

public class MessageUtils {
    private static final int seqLength = 10;

    public static Package hello(UserAgent user) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.HELLO_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        msg.setBody((Object)user);
        return msg;
    }

    public static Package heartBeat() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.HEARTBEAT_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package goodbye() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.CLIENT_GOODBYE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package listen() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.LISTEN_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package subscribe(String topic, SubscriptionMode subscriptionMode, SubcriptionType subcriptionType) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.SUBSCRIBE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        msg.setBody((Object)MessageUtils.generateSubscription(topic, subscriptionMode, subcriptionType));
        return msg;
    }

    public static Package unsubscribe() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.UNSUBSCRIBE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package asyncMessageAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.ASYNC_MESSAGE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package broadcastMessageAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.BROADCAST_MESSAGE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package requestToClientAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.REQUEST_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package responseToClientAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.RESPONSE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static UserAgent generateSubClient(UserAgent agent) {
        UserAgent user = new UserAgent();
        user.setEnv(agent.getEnv());
        user.setHost(agent.getHost());
        user.setPassword(agent.getPassword());
        user.setUsername(agent.getUsername());
        user.setPath(agent.getPath());
        user.setPort(agent.getPort());
        user.setSubsystem(agent.getSubsystem());
        user.setPid(agent.getPid());
        user.setVersion(agent.getVersion());
        user.setIdc(agent.getIdc());
        user.setConsumerGroup(agent.getConsumerGroup());
        user.setProducerGroup(agent.getProducerGroup());
        user.setPurpose(EventMeshCommon.USER_AGENT_PURPOSE_SUB);
        return user;
    }

    public static UserAgent generatePubClient(UserAgent agent) {
        UserAgent user = new UserAgent();
        user.setEnv(agent.getEnv());
        user.setHost(agent.getHost());
        user.setPassword(agent.getPassword());
        user.setUsername(agent.getUsername());
        user.setPath(agent.getPath());
        user.setPort(agent.getPort());
        user.setSubsystem(agent.getSubsystem());
        user.setPid(agent.getPid());
        user.setVersion(agent.getVersion());
        user.setIdc(agent.getIdc());
        user.setProducerGroup(agent.getProducerGroup());
        user.setPurpose(EventMeshCommon.USER_AGENT_PURPOSE_PUB);
        return user;
    }

    private static Subscription generateSubscription(String topic, SubscriptionMode subscriptionMode, SubcriptionType subcriptionType) {
        Subscription subscription = new Subscription();
        ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
        subscriptionItems.add(new SubscriptionItem(topic, subscriptionMode, subcriptionType));
        subscription.setTopicList(subscriptionItems);
        return subscription;
    }

    private static String generateRandomString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append((char)ThreadLocalRandom.current().nextInt(48, 57));
        }
        return builder.toString();
    }
}

