/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.util;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.http.conf.LiteClientConfig;
import org.apache.eventmesh.common.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.RandomLoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.Weight;
import org.apache.eventmesh.common.loadbalance.WeightRoundRobinLoadBalanceSelector;

public class HttpLoadBalanceUtils {
    private static final Pattern IP_PORT_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d{4,5}");
    private static final Pattern IP_PORT_WEIGHT_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d{4,5}:\\d{1,6}");

    public static LoadBalanceSelector<String> createEventMeshServerLoadBalanceSelector(LiteClientConfig liteClientConfig) throws EventMeshException {
        List eventMeshAddrs = Splitter.on((String)";").splitToList((CharSequence)liteClientConfig.getLiteEventMeshAddr());
        if (CollectionUtils.isEmpty((Collection)eventMeshAddrs)) {
            throw new EventMeshException("liteEventMeshAddr can not be empty");
        }
        RandomLoadBalanceSelector eventMeshServerSelector = null;
        switch (liteClientConfig.getLoadBalanceType()) {
            case RANDOM: {
                ArrayList<String> eventMeshAddrList = new ArrayList<String>();
                for (String eventMeshAddr : eventMeshAddrs) {
                    if (!IP_PORT_PATTERN.matcher(eventMeshAddr).matches()) {
                        throw new EventMeshException(String.format("liteEventMeshAddr:%s is not illegal", liteClientConfig.getLiteEventMeshAddr()));
                    }
                    eventMeshAddrList.add(eventMeshAddr);
                }
                eventMeshServerSelector = new RandomLoadBalanceSelector(eventMeshAddrList);
                break;
            }
            case WEIGHT_ROUND_ROBIN: {
                ArrayList<Weight> eventMeshAddrWeightList = new ArrayList<Weight>();
                for (String eventMeshAddrWight : eventMeshAddrs) {
                    if (!IP_PORT_WEIGHT_PATTERN.matcher(eventMeshAddrWight).matches()) {
                        throw new EventMeshException(String.format("liteEventMeshAddr:%s is not illegal", liteClientConfig.getLiteEventMeshAddr()));
                    }
                    int splitIndex = eventMeshAddrWight.lastIndexOf(":");
                    Weight weight = new Weight((Object)eventMeshAddrWight.substring(0, splitIndex), Integer.parseInt(eventMeshAddrWight.substring(splitIndex + 1)));
                    eventMeshAddrWeightList.add(weight);
                }
                eventMeshServerSelector = new WeightRoundRobinLoadBalanceSelector(eventMeshAddrWeightList);
                break;
            }
        }
        if (eventMeshServerSelector == null) {
            throw new EventMeshException("liteEventMeshAddr param illegal,please check");
        }
        return eventMeshServerSelector;
    }
}

