/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.common.EventMeshException;
import org.apache.eventmesh.common.LiteMessage;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRCallbackResponseHandlerAdapter
implements ResponseHandler<String> {
    public Logger logger = LoggerFactory.getLogger(RRCallbackResponseHandlerAdapter.class);
    private long createTime;
    private LiteMessage liteMessage;
    private RRCallback rrCallback;
    private long timeout;

    public RRCallbackResponseHandlerAdapter(LiteMessage liteMessage, RRCallback rrCallback, long timeout) {
        this.liteMessage = liteMessage;
        this.rrCallback = rrCallback;
        this.timeout = timeout;
        this.createTime = System.currentTimeMillis();
    }

    public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            this.rrCallback.onException((Throwable)new EventMeshException(response.toString()));
            return response.toString();
        }
        if (System.currentTimeMillis() - this.createTime > this.timeout) {
            String err = String.format("response too late, bizSeqNo=%s, uniqueId=%s, createTime=%s, ttl=%s, cost=%sms", this.liteMessage.getBizSeqNo(), this.liteMessage.getUniqueId(), DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"), this.timeout, System.currentTimeMillis() - this.createTime);
            this.logger.warn(err);
            this.rrCallback.onException((Throwable)new EventMeshException(err));
            return err;
        }
        String res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
        EventMeshRetObj ret = (EventMeshRetObj)JSON.parseObject((String)res, EventMeshRetObj.class);
        if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            this.rrCallback.onException((Throwable)new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg()));
            return res;
        }
        LiteMessage liteMessage = new LiteMessage();
        try {
            SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JSON.parseObject((String)ret.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
            liteMessage.setContent(replyMessage.body).setProp(replyMessage.properties).setTopic(replyMessage.topic);
            this.rrCallback.onSuccess(liteMessage);
        }
        catch (Exception ex) {
            this.rrCallback.onException((Throwable)new EventMeshException((Throwable)ex));
            return ex.toString();
        }
        return liteMessage.toString();
    }
}

