/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.AbstractLiteClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.LiteClientConfig;
import org.apache.eventmesh.client.http.http.HttpUtil;
import org.apache.eventmesh.client.http.http.RequestParam;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.client.http.producer.RRCallbackResponseHandlerAdapter;
import org.apache.eventmesh.common.EventMeshException;
import org.apache.eventmesh.common.LiteMessage;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteProducer
extends AbstractLiteClient {
    public Logger logger = LoggerFactory.getLogger(LiteProducer.class);
    private AtomicBoolean started = new AtomicBoolean(Boolean.FALSE);

    public LiteProducer(LiteClientConfig liteClientConfig) {
        super(liteClientConfig);
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((this.liteClientConfig != null ? 1 : 0) != 0, (Object)"liteClientConfig can't be null");
        Preconditions.checkState((this.liteClientConfig.getLiteEventMeshAddr() != null ? 1 : 0) != 0, (Object)"liteClientConfig.liteServerAddr can't be null");
        if (this.started.get()) {
            return;
        }
        this.logger.info("LiteProducer starting");
        super.start();
        this.started.compareAndSet(false, true);
        this.logger.info("LiteProducer started");
    }

    @Override
    public void shutdown() throws Exception {
        if (!this.started.get()) {
            return;
        }
        this.logger.info("LiteProducer shutting down");
        super.shutdown();
        this.started.compareAndSet(true, false);
        this.logger.info("LiteProducer shutdown");
    }

    public AtomicBoolean getStarted() {
        return this.started;
    }

    public boolean publish(LiteMessage message) throws Exception {
        EventMeshRetObj ret;
        if (!this.started.get()) {
            this.start();
        }
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getTopic()), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getContent()), (Object)"eventMeshMessage[content] invalid");
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.MSG_SEND_ASYNC.getRequestCode())).addHeader("Env", this.liteClientConfig.getEnv()).addHeader("Idc", this.liteClientConfig.getIdc()).addHeader("Ip", this.liteClientConfig.getIp()).addHeader("Pid", this.liteClientConfig.getPid()).addHeader("Sys", this.liteClientConfig.getSys()).addHeader("Username", this.liteClientConfig.getUserName()).addHeader("Passwd", this.liteClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(3000L).addBody("producerGroup", this.liteClientConfig.getProducerGroup()).addBody("topic", message.getTopic()).addBody("content", message.getContent()).addBody("ttl", message.getPropKey("ttl")).addBody("bizSeqNo", message.getBizSeqNo()).addBody("uniqueId", message.getUniqueId());
        long startTime = System.currentTimeMillis();
        String target = this.selectEventMesh();
        String res = "";
        try (CloseableHttpClient httpClient = this.setHttpClient();){
            res = HttpUtil.post(httpClient, target, requestParam);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("publish async message, targetEventMesh:{}, cost:{}ms, message:{}, rtn:{}", new Object[]{target, System.currentTimeMillis() - startTime, message, res});
        }
        if ((ret = (EventMeshRetObj)JSON.parseObject((String)res, EventMeshRetObj.class)).getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            return Boolean.TRUE;
        }
        throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
    }

    public String selectEventMesh() {
        if (this.liteClientConfig.isUseTls()) {
            return "https://" + (String)this.eventMeshServerSelector.select();
        }
        return "http://" + (String)this.eventMeshServerSelector.select();
    }

    public LiteMessage request(LiteMessage message, long timeout) throws Exception {
        EventMeshRetObj ret;
        if (!this.started.get()) {
            this.start();
        }
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getTopic()), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getContent()), (Object)"eventMeshMessage[content] invalid");
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.MSG_SEND_SYNC.getRequestCode())).addHeader("Env", this.liteClientConfig.getEnv()).addHeader("Idc", this.liteClientConfig.getIdc()).addHeader("Ip", this.liteClientConfig.getIp()).addHeader("Pid", this.liteClientConfig.getPid()).addHeader("Sys", this.liteClientConfig.getSys()).addHeader("Username", this.liteClientConfig.getUserName()).addHeader("Passwd", this.liteClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(timeout).addBody("producerGroup", this.liteClientConfig.getProducerGroup()).addBody("topic", message.getTopic()).addBody("content", message.getContent()).addBody("ttl", String.valueOf(timeout)).addBody("bizSeqNo", message.getBizSeqNo()).addBody("uniqueId", message.getUniqueId());
        long startTime = System.currentTimeMillis();
        String target = this.selectEventMesh();
        String res = "";
        try (CloseableHttpClient httpClient = this.setHttpClient();){
            res = HttpUtil.post(httpClient, target, requestParam);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("publish sync message by await, targetEventMesh:{}, cost:{}ms, message:{}, rtn:{}", new Object[]{target, System.currentTimeMillis() - startTime, message, res});
        }
        if ((ret = (EventMeshRetObj)JSON.parseObject((String)res, EventMeshRetObj.class)).getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            LiteMessage eventMeshMessage = new LiteMessage();
            SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JSON.parseObject((String)ret.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
            eventMeshMessage.setContent(replyMessage.body).setProp(replyMessage.properties).setTopic(replyMessage.topic);
            return eventMeshMessage;
        }
        return null;
    }

    public void request(LiteMessage message, RRCallback rrCallback, long timeout) throws Exception {
        if (!this.started.get()) {
            this.start();
        }
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getTopic()), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)message.getContent()), (Object)"eventMeshMessage[content] invalid");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{rrCallback}), (Object)"rrCallback invalid");
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.MSG_SEND_SYNC.getRequestCode())).addHeader("Env", this.liteClientConfig.getEnv()).addHeader("Idc", this.liteClientConfig.getIdc()).addHeader("Ip", this.liteClientConfig.getIp()).addHeader("Pid", this.liteClientConfig.getPid()).addHeader("Sys", this.liteClientConfig.getSys()).addHeader("Username", this.liteClientConfig.getUserName()).addHeader("Passwd", this.liteClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(timeout).addBody("producerGroup", this.liteClientConfig.getProducerGroup()).addBody("topic", message.getTopic()).addBody("content", message.getContent()).addBody("ttl", String.valueOf(timeout)).addBody("bizSeqNo", message.getBizSeqNo()).addBody("uniqueId", message.getUniqueId());
        long startTime = System.currentTimeMillis();
        String target = this.selectEventMesh();
        try (CloseableHttpClient httpClient = this.setHttpClient();){
            HttpUtil.post(httpClient, null, target, requestParam, new RRCallbackResponseHandlerAdapter(message, rrCallback, timeout));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("publish sync message by async, target:{}, cost:{}, message:{}", new Object[]{target, System.currentTimeMillis() - startTime, message});
        }
    }
}

