/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.http;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.http.RequestParam;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static String post(CloseableHttpClient client, String uri, RequestParam requestParam) throws Exception {
        final ResponseHolder responseHolder = new ResponseHolder();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtil.post(client, null, uri, requestParam, new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                countDownLatch.countDown();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}", (Object)responseHolder);
                }
                return responseHolder.response;
            }
        });
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static String post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam) throws Exception {
        final ResponseHolder responseHolder = new ResponseHolder();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtil.post(client, forwardAgent, uri, requestParam, new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                countDownLatch.countDown();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}", (Object)responseHolder);
                }
                return responseHolder.response;
            }
        });
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static void post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws Exception {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((responseHandler != null ? 1 : 0) != 0, (Object)"responseHandler can't be null");
        Preconditions.checkState((requestParam.getHttpMethod() == HttpMethod.POST ? 1 : 0) != 0, (Object)"invalid requestParam httpMethod");
        HttpPost httpPost = new HttpPost(uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(requestParam.getBody())) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : requestParam.getBody().entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpPost.setConfig(configBuilder.build());
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)httpPost);
        }
        client.execute((HttpUriRequest)httpPost, responseHandler);
    }

    public static void get(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws Exception {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((requestParam.getHttpMethod() == HttpMethod.GET ? 1 : 0) != 0, (Object)"invalid requestParam httpMethod");
        if (MapUtils.isNotEmpty(requestParam.getQueryParamsMap())) {
            uri = uri + "?" + requestParam.getQueryParams();
        }
        HttpGet httpGet = new HttpGet(uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpGet.setConfig(configBuilder.build());
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)httpGet);
        }
        client.execute((HttpUriRequest)httpGet, responseHandler);
    }

    public static String get(CloseableHttpClient client, String url, RequestParam requestParam) throws Exception {
        final ResponseHolder responseHolder = new ResponseHolder();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtil.get(client, null, url, requestParam, new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                countDownLatch.countDown();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}", (Object)responseHolder);
                }
                return responseHolder.response;
            }
        });
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static String get(CloseableHttpClient client, HttpHost forwardAgent, String url, RequestParam requestParam) throws Exception {
        final ResponseHolder responseHolder = new ResponseHolder();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtil.get(client, forwardAgent, url, requestParam, new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                countDownLatch.countDown();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}", (Object)responseHolder);
                }
                return responseHolder.response;
            }
        });
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static class ResponseHolder {
        public String response;

        public String toString() {
            return "ResponseHolder=" + this.response + "";
        }
    }
}

