/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.client.http.AbstractLiteClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.RemotingServer;
import org.apache.eventmesh.client.http.conf.LiteClientConfig;
import org.apache.eventmesh.client.http.consumer.listener.LiteMessageListener;
import org.apache.eventmesh.client.http.http.HttpUtil;
import org.apache.eventmesh.client.http.http.RequestParam;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.common.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.common.EventMeshException;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ClientType;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteConsumer
extends AbstractLiteClient {
    public Logger logger = LoggerFactory.getLogger(LiteConsumer.class);
    private RemotingServer remotingServer;
    private ThreadPoolExecutor consumeExecutor;
    protected LiteClientConfig eventMeshClientConfig;
    private List<SubscriptionItem> subscription = Lists.newArrayList();
    private LiteMessageListener messageListener;
    protected final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4, new EventMeshThreadFactoryImpl("TCPClientScheduler", true));
    private AtomicBoolean started = new AtomicBoolean(Boolean.FALSE);

    public LiteConsumer(LiteClientConfig liteClientConfig) throws Exception {
        super(liteClientConfig);
        this.consumeExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)liteClientConfig.getConsumeThreadCore(), (int)liteClientConfig.getConsumeThreadMax(), (String)"eventMesh-client-consume-");
        this.eventMeshClientConfig = liteClientConfig;
    }

    public LiteConsumer(LiteClientConfig liteClientConfig, ThreadPoolExecutor customExecutor) {
        super(liteClientConfig);
        this.consumeExecutor = customExecutor;
        this.eventMeshClientConfig = liteClientConfig;
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((this.eventMeshClientConfig != null ? 1 : 0) != 0, (Object)"eventMeshClientConfig can't be null");
        Preconditions.checkState((this.consumeExecutor != null ? 1 : 0) != 0, (Object)"consumeExecutor can't be null");
        this.logger.info("LiteConsumer starting");
        super.start();
        this.started.compareAndSet(false, true);
        this.logger.info("LiteConsumer started");
    }

    @Override
    public void shutdown() throws Exception {
        this.logger.info("LiteConsumer shutting down");
        super.shutdown();
        if (this.consumeExecutor != null) {
            this.consumeExecutor.shutdown();
        }
        this.scheduler.shutdown();
        this.started.compareAndSet(true, false);
        this.logger.info("LiteConsumer shutdown");
    }

    public boolean subscribe(List<SubscriptionItem> topicList, String url) throws Exception {
        EventMeshRetObj ret;
        this.subscription.addAll(topicList);
        if (!this.started.get()) {
            this.start();
        }
        RequestParam subscribeParam = this.generateSubscribeRequestParam(topicList, url);
        long startTime = System.currentTimeMillis();
        String target = this.selectEventMesh();
        String subRes = "";
        try (CloseableHttpClient httpClient = this.setHttpClient();){
            subRes = HttpUtil.post(httpClient, target, subscribeParam);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("subscribe message by await, targetEventMesh:{}, cost:{}ms, subscribeParam:{}, rtn:{}", new Object[]{target, System.currentTimeMillis() - startTime, JSON.toJSONString((Object)subscribeParam), subRes});
        }
        if ((ret = (EventMeshRetObj)JSON.parseObject((String)subRes, EventMeshRetObj.class)).getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            return Boolean.TRUE;
        }
        throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
    }

    private RequestParam generateSubscribeRequestParam(List<SubscriptionItem> topicList, String url) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.SUBSCRIBE.getRequestCode())).addHeader("Env", this.eventMeshClientConfig.getEnv()).addHeader("Idc", this.eventMeshClientConfig.getIdc()).addHeader("Ip", this.eventMeshClientConfig.getIp()).addHeader("Pid", this.eventMeshClientConfig.getPid()).addHeader("Sys", this.eventMeshClientConfig.getSys()).addHeader("Username", this.eventMeshClientConfig.getUserName()).addHeader("Passwd", this.eventMeshClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(3000L).addBody("topic", JSONObject.toJSONString(topicList)).addBody("consumerGroup", this.eventMeshClientConfig.getConsumerGroup()).addBody("url", url);
        return requestParam;
    }

    private RequestParam generateHeartBeatRequestParam(List<SubscriptionItem> topics, String url) {
        ArrayList<HeartbeatRequestBody.HeartbeatEntity> heartbeatEntities = new ArrayList<HeartbeatRequestBody.HeartbeatEntity>();
        for (SubscriptionItem item : topics) {
            HeartbeatRequestBody.HeartbeatEntity heartbeatEntity = new HeartbeatRequestBody.HeartbeatEntity();
            heartbeatEntity.topic = item.getTopic();
            heartbeatEntity.url = url;
            heartbeatEntities.add(heartbeatEntity);
        }
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.HEARTBEAT.getRequestCode())).addHeader("Env", this.eventMeshClientConfig.getEnv()).addHeader("Idc", this.eventMeshClientConfig.getIdc()).addHeader("Ip", this.eventMeshClientConfig.getIp()).addHeader("Pid", this.eventMeshClientConfig.getPid()).addHeader("Sys", this.eventMeshClientConfig.getSys()).addHeader("Username", this.eventMeshClientConfig.getUserName()).addHeader("Passwd", this.eventMeshClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(3000L).addBody("clientType", ClientType.SUB.name()).addBody("consumerGroup", this.eventMeshClientConfig.getConsumerGroup()).addBody("heartbeatEntities", JSON.toJSONString(heartbeatEntities));
        return requestParam;
    }

    public void heartBeat(final List<SubscriptionItem> topicList, final String url) throws Exception {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    EventMeshRetObj ret;
                    if (!LiteConsumer.this.started.get()) {
                        LiteConsumer.this.start();
                    }
                    RequestParam requestParam = LiteConsumer.this.generateHeartBeatRequestParam(topicList, url);
                    long startTime = System.currentTimeMillis();
                    String target = LiteConsumer.this.selectEventMesh();
                    String res = "";
                    try (CloseableHttpClient httpClient = LiteConsumer.this.setHttpClient();){
                        res = HttpUtil.post(httpClient, target, requestParam);
                    }
                    if (LiteConsumer.this.logger.isDebugEnabled()) {
                        LiteConsumer.this.logger.debug("heartBeat message by await, targetEventMesh:{}, cost:{}ms, rtn:{}", new Object[]{target, System.currentTimeMillis() - startTime, res});
                    }
                    if ((ret = (EventMeshRetObj)JSON.parseObject((String)res, EventMeshRetObj.class)).getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                        throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
                    }
                }
                catch (Exception e) {
                    LiteConsumer.this.logger.error("send heartBeat error", (Throwable)e);
                }
            }
        }, EventMeshCommon.HEATBEAT, EventMeshCommon.HEATBEAT, TimeUnit.MILLISECONDS);
    }

    public boolean unsubscribe(List<String> topicList, String url) throws Exception {
        EventMeshRetObj ret;
        HashSet<String> unSub = new HashSet<String>(topicList);
        Iterator<SubscriptionItem> itr = this.subscription.iterator();
        while (itr.hasNext()) {
            SubscriptionItem item = itr.next();
            if (!unSub.contains(item.getTopic())) continue;
            itr.remove();
        }
        RequestParam unSubscribeParam = this.generateUnSubscribeRequestParam(topicList, url);
        long startTime = System.currentTimeMillis();
        String target = this.selectEventMesh();
        String unSubRes = "";
        try (CloseableHttpClient httpClient = this.setHttpClient();){
            unSubRes = HttpUtil.post(httpClient, target, unSubscribeParam);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unSubscribe message by await, targetEventMesh:{}, cost:{}ms, unSubscribeParam:{}, rtn:{}", new Object[]{target, System.currentTimeMillis() - startTime, JSON.toJSONString((Object)unSubscribeParam), unSubRes});
        }
        if ((ret = (EventMeshRetObj)JSON.parseObject((String)unSubRes, EventMeshRetObj.class)).getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            return Boolean.TRUE;
        }
        throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
    }

    private RequestParam generateUnSubscribeRequestParam(List<String> topicList, String url) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("Code", String.valueOf(RequestCode.UNSUBSCRIBE.getRequestCode())).addHeader("Env", this.eventMeshClientConfig.getEnv()).addHeader("Idc", this.eventMeshClientConfig.getIdc()).addHeader("Ip", this.eventMeshClientConfig.getIp()).addHeader("Pid", this.eventMeshClientConfig.getPid()).addHeader("Sys", this.eventMeshClientConfig.getSys()).addHeader("Username", this.eventMeshClientConfig.getUserName()).addHeader("Passwd", this.eventMeshClientConfig.getPassword()).addHeader("Version", ProtocolVersion.V1.getVersion()).addHeader("Language", "JAVA").setTimeout(3000L).addBody("topic", JSONObject.toJSONString(topicList)).addBody("consumerGroup", this.eventMeshClientConfig.getConsumerGroup()).addBody("url", url);
        return requestParam;
    }

    public void registerMessageListener(LiteMessageListener messageListener) throws EventMeshException {
        this.messageListener = messageListener;
        this.remotingServer.registerMessageListener(this.messageListener);
    }

    public String selectEventMesh() {
        if (this.liteClientConfig.isUseTls()) {
            return "https://" + (String)this.eventMeshServerSelector.select();
        }
        return "http://" + (String)this.eventMeshServerSelector.select();
    }
}

