/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.consumer.HandleResult;
import org.apache.eventmesh.client.http.consumer.context.LiteConsumeContext;
import org.apache.eventmesh.client.http.consumer.listener.LiteMessageListener;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.LiteMessage;
import org.apache.eventmesh.common.ThreadUtil;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.PushMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ClientRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.PushMessageRequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public AtomicBoolean started = new AtomicBoolean(Boolean.FALSE);
    public AtomicBoolean inited = new AtomicBoolean(Boolean.FALSE);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private int port = RandomUtils.nextInt((int)1000, (int)20000);
    private DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(false);
    private ThreadPoolExecutor consumeExecutor;
    private LiteMessageListener messageListener;

    public RemotingServer() {
    }

    public RemotingServer(int port) {
        this.port = port;
    }

    public RemotingServer(ThreadPoolExecutor consumeExecutor) {
        this.consumeExecutor = consumeExecutor;
    }

    public RemotingServer(int port, ThreadPoolExecutor consumeExecutor) {
        this.port = port;
        this.consumeExecutor = consumeExecutor;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConsumeExecutor(ThreadPoolExecutor consumeExecutor) {
        this.consumeExecutor = consumeExecutor;
    }

    public void registerMessageListener(LiteMessageListener eventMeshMessageListener) {
        this.messageListener = eventMeshMessageListener;
    }

    private EventLoopGroup initBossGroup() {
        this.bossGroup = new NioEventLoopGroup(1, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "endPointBoss-" + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        return this.bossGroup;
    }

    private EventLoopGroup initWokerGroup() {
        this.workerGroup = new NioEventLoopGroup(2, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "endpointWorker-" + this.count.incrementAndGet());
                return t;
            }
        });
        return this.workerGroup;
    }

    public String getEndpointURL() {
        return String.format("http://%s:%s", IPUtil.getLocalAddress(), this.port);
    }

    public void init() throws Exception {
        this.initBossGroup();
        this.initWokerGroup();
        this.inited.compareAndSet(false, true);
    }

    public void start() throws Exception {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)b.group(RemotingServer.this.bossGroup, RemotingServer.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), new HttpObjectAggregator(Integer.MAX_VALUE), new HTTPHandler()});
                    }
                }).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
                try {
                    RemotingServer.this.logger.info("EventMesh Client[{}] Started......", (Object)RemotingServer.this.port);
                    ChannelFuture future = b.bind(RemotingServer.this.port).sync();
                    future.channel().closeFuture().sync();
                    RemotingServer.this.started.compareAndSet(false, true);
                }
                catch (Exception e) {
                    RemotingServer.this.bossGroup.shutdownGracefully();
                    RemotingServer.this.workerGroup.shutdownGracefully();
                }
            }
        };
        Thread t = new Thread(r, "eventMesh-client-remoting-server");
        t.start();
    }

    class HTTPHandler
    extends SimpleChannelInboundHandler<HttpRequest> {
        HTTPHandler() {
        }

        private Map<String, Object> parseHTTPHeader(HttpRequest fullReq) {
            HashMap<String, Object> headerParam = new HashMap<String, Object>();
            for (String key : fullReq.headers().names()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_TYPE.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.ACCEPT_ENCODING.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_LENGTH.toString(), (CharSequence)key)) continue;
                headerParam.put(key, fullReq.headers().get(key));
            }
            return headerParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void channelRead0(final ChannelHandlerContext ctx, HttpRequest httpRequest) throws Exception {
            HttpPostRequestDecoder decoder = null;
            try {
                if (!httpRequest.decoderResult().isSuccess()) {
                    this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                String protocolVersion = StringUtils.deleteWhitespace((String)httpRequest.headers().get("Version"));
                if (StringUtils.isBlank((CharSequence)protocolVersion) || !ProtocolVersion.contains((String)protocolVersion)) {
                    httpRequest.headers().set("Version", (Object)ProtocolVersion.V1.getVersion());
                }
                HashMap bodyMap = new HashMap();
                if (httpRequest.method() == HttpMethod.GET) {
                    QueryStringDecoder getDecoder = new QueryStringDecoder(httpRequest.uri());
                    for (Map.Entry entry : getDecoder.parameters().entrySet()) {
                        bodyMap.put(entry.getKey(), ((List)entry.getValue()).get(0));
                    }
                } else {
                    if (httpRequest.method() != HttpMethod.POST) {
                        this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                        return;
                    }
                    decoder = new HttpPostRequestDecoder((HttpDataFactory)RemotingServer.this.defaultHttpDataFactory, httpRequest);
                    List parmList = decoder.getBodyHttpDatas();
                    for (InterfaceHttpData parm : parmList) {
                        if (parm.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                        Attribute data = (Attribute)parm;
                        bodyMap.put(data.getName(), data.getValue());
                    }
                }
                String requestCode = httpRequest.method() == HttpMethod.POST ? StringUtils.deleteWhitespace((String)httpRequest.headers().get("Code")) : MapUtils.getString(bodyMap, (Object)StringUtils.lowerCase((String)"Code"), (String)"");
                final HttpCommand requestCommand = new HttpCommand(httpRequest.method().name(), httpRequest.protocolVersion().protocolName(), requestCode);
                if (StringUtils.isBlank((CharSequence)requestCode) || !StringUtils.isNumeric((CharSequence)requestCode) || !String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode()).equals(requestCode) && !String.valueOf(RequestCode.HTTP_PUSH_CLIENT_SYNC.getRequestCode()).equals(requestCode)) {
                    RemotingServer.this.logger.error("receive invalid requestCode, {}", (Object)requestCode);
                    HttpCommand responseCommand = requestCommand.createHttpCommandResponse(ClientRetCode.OK.getRetCode(), ClientRetCode.OK.getErrMsg());
                    this.sendResponse(ctx, responseCommand.httpResponse());
                    return;
                }
                requestCommand.setHeader(Header.buildHeader((String)requestCode, this.parseHTTPHeader(httpRequest)));
                requestCommand.setBody(Body.buildBody((String)requestCode, bodyMap));
                if (RemotingServer.this.logger.isDebugEnabled()) {
                    RemotingServer.this.logger.debug("{}", (Object)requestCommand);
                }
                PushMessageRequestHeader pushMessageRequestHeader = (PushMessageRequestHeader)requestCommand.header;
                PushMessageRequestBody pushMessageRequestBody = (PushMessageRequestBody)requestCommand.body;
                String topic = pushMessageRequestBody.getTopic();
                final LiteConsumeContext eventMeshConsumeContext = new LiteConsumeContext(pushMessageRequestHeader.getEventMeshIp(), pushMessageRequestHeader.getEventMeshEnv(), pushMessageRequestHeader.getEventMeshIdc(), pushMessageRequestHeader.getEventMeshCluster());
                final LiteMessage liteMessage = new LiteMessage(pushMessageRequestBody.getBizSeqNo(), pushMessageRequestBody.getUniqueId(), topic, pushMessageRequestBody.getContent());
                for (Map.Entry entry : pushMessageRequestBody.getExtFields().entrySet()) {
                    liteMessage.addProp((String)entry.getKey(), (String)entry.getValue());
                }
                RemotingServer.this.consumeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (RemotingServer.this.messageListener.reject()) {
                                HttpCommand responseCommand = requestCommand.createHttpCommandResponse(HTTPHandler.this.handleResult2ClientRetCode(HandleResult.RETRY).getRetCode(), HTTPHandler.this.handleResult2ClientRetCode(HandleResult.RETRY).getErrMsg());
                                HTTPHandler.this.sendResponse(ctx, responseCommand.httpResponse());
                                return;
                            }
                            HandleResult handleResult = RemotingServer.this.messageListener.handle(liteMessage, eventMeshConsumeContext);
                            if (RemotingServer.this.logger.isDebugEnabled()) {
                                RemotingServer.this.logger.info("bizSeqNo:{}, topic:{}, handleResult:{}", new Object[]{liteMessage.getBizSeqNo(), liteMessage.getTopic(), handleResult});
                            }
                            HttpCommand responseCommand = requestCommand.createHttpCommandResponse(HTTPHandler.this.handleResult2ClientRetCode(handleResult).getRetCode(), HTTPHandler.this.handleResult2ClientRetCode(handleResult).getErrMsg());
                            HTTPHandler.this.sendResponse(ctx, responseCommand.httpResponse());
                        }
                        catch (Exception e) {
                            RemotingServer.this.logger.error("process error", (Throwable)e);
                        }
                    }
                });
                return;
            }
            catch (Exception ex) {
                RemotingServer.this.logger.error("HTTPHandler.channelRead0 err", (Throwable)ex);
                return;
            }
            finally {
                try {
                    decoder.destroy();
                }
                catch (Exception exception) {}
            }
        }

        public ClientRetCode handleResult2ClientRetCode(HandleResult handleResult) {
            if (handleResult == HandleResult.OK) {
                return ClientRetCode.OK;
            }
            if (handleResult == HandleResult.FAIL) {
                return ClientRetCode.FAIL;
            }
            if (handleResult == HandleResult.NOLISTEN) {
                return ClientRetCode.NOLISTEN;
            }
            if (handleResult == HandleResult.RETRY) {
                return ClientRetCode.RETRY;
            }
            return ClientRetCode.OK;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (null != cause) {
                cause.printStackTrace();
            }
            if (null != ctx) {
                ctx.close();
            }
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(HttpHeaderValues.TEXT_PLAIN + "; charset=" + "UTF-8"));
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private void sendResponse(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (!f.isSuccess()) {
                        RemotingServer.this.logger.warn("send response to [{}] fail, will close this channel", (Object)IPUtil.parseChannelRemoteAddr((Channel)f.channel()));
                        f.channel().close();
                        return;
                    }
                }
            });
        }

        public void shutdown() throws Exception {
            if (RemotingServer.this.bossGroup != null) {
                RemotingServer.this.bossGroup.shutdownGracefully();
            }
            ThreadUtil.randomSleep((int)30);
            if (RemotingServer.this.workerGroup != null) {
                RemotingServer.this.workerGroup.shutdownGracefully();
            }
            RemotingServer.this.started.compareAndSet(true, false);
            RemotingServer.this.inited.compareAndSet(true, false);
        }
    }
}

