/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http;

import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.eventmesh.client.http.conf.LiteClientConfig;
import org.apache.eventmesh.client.http.ssl.MyX509TrustManager;
import org.apache.eventmesh.client.http.util.HttpLoadBalanceUtils;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLiteClient {
    public Logger logger = LoggerFactory.getLogger(AbstractLiteClient.class);
    protected LiteClientConfig liteClientConfig;
    protected LoadBalanceSelector<String> eventMeshServerSelector;

    public AbstractLiteClient(LiteClientConfig liteClientConfig) {
        this.liteClientConfig = liteClientConfig;
    }

    public void start() throws Exception {
        this.eventMeshServerSelector = HttpLoadBalanceUtils.createEventMeshServerLoadBalanceSelector(this.liteClientConfig);
    }

    public LiteClientConfig getLiteClientConfig() {
        return this.liteClientConfig;
    }

    public void shutdown() throws Exception {
        this.logger.info("AbstractLiteClient shutdown");
    }

    public CloseableHttpClient setHttpClient() throws Exception {
        if (!this.liteClientConfig.isUseTls()) {
            return HttpClients.createDefault();
        }
        SSLContext sslContext = null;
        try {
            String protocol = System.getProperty("ssl.client.protocol", "TLSv1.2");
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, tm, new SecureRandom());
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
        }
        catch (Exception e) {
            this.logger.error("Error in creating HttpClient.", (Throwable)e);
            throw e;
        }
    }
}

