/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingHelper {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static Logger logger = LoggerFactory.getLogger(RemotingHelper.class);

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuilder sb = new StringBuilder();
        if (e != null) {
            sb.append(e.toString());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement elment = stackTrace[0];
                sb.append(", ");
                sb.append(elment.toString());
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(":");
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        InetSocketAddress isa = new InetSocketAddress(host, Integer.parseInt(port));
        return isa;
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        String addr;
        if (socketAddress != null && (addr = socketAddress.toString()).length() > 0) {
            return addr.substring(1);
        }
        return "";
    }
}

