/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.openmessaging.api.Message;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadUtil;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.constants.EventMeshVersion;
import org.apache.eventmesh.runtime.util.OMSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshUtil {
    public static Logger logger = LoggerFactory.getLogger(EventMeshUtil.class);

    public static String buildPushMsgSeqNo() {
        return StringUtils.rightPad((String)String.valueOf(System.currentTimeMillis()), (int)6) + String.valueOf(RandomStringUtils.randomNumeric((int)4));
    }

    public static String buildMeshClientID(String clientGroup, String meshCluster) {
        return StringUtils.trim((String)clientGroup) + "(" + StringUtils.trim((String)meshCluster) + ")-" + EventMeshVersion.getCurrentVersionDesc() + "-" + ThreadUtil.getPID();
    }

    public static String buildMeshTcpClientID(String clientSysId, String purpose, String meshCluster) {
        return StringUtils.trim((String)clientSysId) + "-" + StringUtils.trim((String)purpose) + "-" + StringUtils.trim((String)meshCluster) + "-" + EventMeshVersion.getCurrentVersionDesc() + "-" + ThreadUtil.getPID();
    }

    public static String buildClientGroup(String systemId) {
        return systemId;
    }

    public static String stackTrace(Throwable e) {
        return EventMeshUtil.stackTrace(e, 0);
    }

    public static String stackTrace(Throwable e, int level) {
        if (e == null) {
            return null;
        }
        StackTraceElement[] eles = e.getStackTrace();
        level = level == 0 ? eles.length : level;
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage()).append(System.lineSeparator());
        int innerLevel = 0;
        for (StackTraceElement ele : eles) {
            sb.append(ele.toString()).append(System.lineSeparator());
            if (++innerLevel >= level) break;
        }
        return sb.toString();
    }

    public static ObjectMapper createJsoner() {
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        jsonMapper.setTimeZone(TimeZone.getDefault());
        return jsonMapper;
    }

    public static String printMqMessage(EventMeshMessage eventMeshMessage) {
        Map properties = eventMeshMessage.getProperties();
        String keys = (String)properties.get("KEYS");
        if (!StringUtils.isNotBlank((CharSequence)keys)) {
            keys = (String)properties.get("keys");
        }
        String result = String.format("Message [topic=%s,TTL=%s,uniqueId=%s,bizSeq=%s]", eventMeshMessage.getTopic(), properties.get("TTL"), properties.get("RR_REQUEST_UNIQ_ID"), keys);
        return result;
    }

    public static String getMessageBizSeq(Message msg) {
        Properties properties = msg.getSystemProperties();
        String keys = properties.getProperty("KEYS");
        if (!StringUtils.isNotBlank((CharSequence)keys)) {
            keys = properties.getProperty("keys");
        }
        return keys;
    }

    public static Message decodeMessage(EventMeshMessage eventMeshMessage) {
        Message omsMsg = new Message();
        omsMsg.setBody(eventMeshMessage.getBody().getBytes());
        omsMsg.setTopic(eventMeshMessage.getTopic());
        Properties systemProperties = new Properties();
        Properties userProperties = new Properties();
        Set entries = eventMeshMessage.getProperties().entrySet();
        for (Map.Entry entry : entries) {
            if (OMSUtil.isOMSHeader((String)entry.getKey())) {
                systemProperties.put(entry.getKey(), entry.getValue());
                continue;
            }
            userProperties.put(entry.getKey(), entry.getValue());
        }
        systemProperties.put("DESTINATION", eventMeshMessage.getTopic());
        omsMsg.setSystemProperties(systemProperties);
        omsMsg.setUserProperties(userProperties);
        return omsMsg;
    }

    public static EventMeshMessage encodeMessage(Message omsMessage) throws Exception {
        long deliverTime;
        EventMeshMessage eventMeshMessage = new EventMeshMessage();
        eventMeshMessage.setBody(new String(omsMessage.getBody(), StandardCharsets.UTF_8));
        Properties sysHeaders = omsMessage.getSystemProperties();
        Properties userHeaders = omsMessage.getUserProperties();
        eventMeshMessage.setTopic(sysHeaders.getProperty("DESTINATION"));
        if (sysHeaders.containsKey("START_TIME") && (deliverTime = StringUtils.isBlank((CharSequence)sysHeaders.getProperty("START_TIME")) ? 0L : Long.parseLong(sysHeaders.getProperty("START_TIME"))) > 0L) {
            eventMeshMessage.getProperties().put("START_TIME", String.valueOf(deliverTime));
        }
        for (String key : userHeaders.stringPropertyNames()) {
            eventMeshMessage.getProperties().put(key, userHeaders.getProperty(key));
        }
        for (String key : sysHeaders.stringPropertyNames()) {
            eventMeshMessage.getProperties().put(key, sysHeaders.getProperty(key));
        }
        return eventMeshMessage;
    }

    public static String getLocalAddr() {
        String priority = System.getProperty("networkInterface.priority", "bond1<eth1<eth0");
        logger.debug("networkInterface.priority: {}", (Object)priority);
        ArrayList<String> preferList = new ArrayList<String>();
        for (String eth : priority.split("<")) {
            preferList.add(eth);
        }
        NetworkInterface preferNetworkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
            while (enumeration1.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration1.nextElement();
                if (!preferList.contains(networkInterface.getName())) continue;
                if (preferNetworkInterface == null) {
                    preferNetworkInterface = networkInterface;
                    continue;
                }
                if (preferList.indexOf(networkInterface.getName()) <= preferList.indexOf(preferNetworkInterface.getName())) continue;
                preferNetworkInterface = networkInterface;
            }
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            if (preferNetworkInterface != null) {
                logger.debug("use preferNetworkInterface:{}", (Object)preferNetworkInterface);
                Enumeration<InetAddress> en = preferNetworkInterface.getInetAddresses();
                EventMeshUtil.getIpResult(ipv4Result, ipv6Result, en);
            } else {
                logger.debug("no preferNetworkInterface");
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                    EventMeshUtil.getIpResult(ipv4Result, ipv6Result, en);
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                    return ip;
                }
                return ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return EventMeshUtil.normalizeHostAddress(localHost);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    private static void getIpResult(ArrayList<String> ipv4Result, ArrayList<String> ipv6Result, Enumeration<InetAddress> en) {
        while (en.hasMoreElements()) {
            InetAddress address = en.nextElement();
            if (address.isLoopbackAddress()) continue;
            if (address instanceof Inet6Address) {
                ipv6Result.add(EventMeshUtil.normalizeHostAddress(address));
                continue;
            }
            ipv4Result.add(EventMeshUtil.normalizeHostAddress(address));
        }
    }

    public static String buildUserAgentClientId(UserAgent client) {
        if (client == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(client.getSubsystem()).append("-").append("-").append(client.getPid()).append("-").append(client.getHost()).append(":").append(client.getPort());
        return sb.toString();
    }
}

