/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.tcp;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpConnectionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpMonitor {
    private EventMeshTCPServer eventMeshTCPServer;
    private final Logger tcpLogger = LoggerFactory.getLogger((String)"tcpMonitor");
    private final Logger appLogger = LoggerFactory.getLogger((String)"appMonitor");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int delay = 60000;
    private static int period = 60000;
    private static int PRINT_THREADPOOLSTATE_INTERVAL = 1;
    private AtomicInteger client2eventMeshMsgNum;
    private AtomicInteger eventMesh2mqMsgNum;
    private AtomicInteger mq2eventMeshMsgNum;
    private AtomicInteger eventMesh2clientMsgNum;
    private int client2eventMeshTPS;
    private int eventMesh2clientTPS;
    private int eventMesh2mqTPS;
    private int mq2eventMeshTPS;
    private int allTPS;
    private int subTopicNum;
    public ScheduledFuture<?> monitorTpsTask;
    public ScheduledFuture<?> monitorThreadPoolTask;

    public EventMeshTcpMonitor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void init() throws Exception {
        this.client2eventMeshMsgNum = new AtomicInteger(0);
        this.eventMesh2mqMsgNum = new AtomicInteger(0);
        this.mq2eventMeshMsgNum = new AtomicInteger(0);
        this.eventMesh2clientMsgNum = new AtomicInteger(0);
        this.logger.info("EventMeshTcpMonitor inited......");
    }

    public void start() throws Exception {
        this.monitorTpsTask = this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                int msgNum = EventMeshTcpMonitor.this.client2eventMeshMsgNum.intValue();
                EventMeshTcpMonitor.this.client2eventMeshMsgNum = new AtomicInteger(0);
                EventMeshTcpMonitor.this.client2eventMeshTPS = 1000 * msgNum / period;
                msgNum = EventMeshTcpMonitor.this.eventMesh2clientMsgNum.intValue();
                EventMeshTcpMonitor.this.eventMesh2clientMsgNum = new AtomicInteger(0);
                EventMeshTcpMonitor.this.eventMesh2clientTPS = 1000 * msgNum / period;
                msgNum = EventMeshTcpMonitor.this.eventMesh2mqMsgNum.intValue();
                EventMeshTcpMonitor.this.eventMesh2mqMsgNum = new AtomicInteger(0);
                EventMeshTcpMonitor.this.eventMesh2mqTPS = 1000 * msgNum / period;
                msgNum = EventMeshTcpMonitor.this.mq2eventMeshMsgNum.intValue();
                EventMeshTcpMonitor.this.mq2eventMeshMsgNum = new AtomicInteger(0);
                EventMeshTcpMonitor.this.mq2eventMeshTPS = 1000 * msgNum / period;
                EventMeshTcpMonitor.this.allTPS = EventMeshTcpMonitor.this.client2eventMeshTPS + EventMeshTcpMonitor.this.eventMesh2clientTPS;
                ConcurrentHashMap<InetSocketAddress, Session> sessionMap = EventMeshTcpMonitor.this.eventMeshTCPServer.getClientSessionGroupMapping().getSessionMap();
                Iterator<Session> sessionIterator = sessionMap.values().iterator();
                HashSet topicSet = new HashSet();
                while (sessionIterator.hasNext()) {
                    Session session = sessionIterator.next();
                    AtomicLong deliveredMsgsCount = session.getPusher().getDeliveredMsgsCount();
                    AtomicLong deliveredFailCount = session.getPusher().getDeliverFailMsgsCount();
                    int unAckMsgsCount = session.getPusher().getTotalUnackMsgs();
                    int sendTopics = session.getSessionContext().sendTopics.size();
                    int subscribeTopics = session.getSessionContext().subscribeTopics.size();
                    EventMeshTcpMonitor.this.tcpLogger.info("session|deliveredFailCount={}|deliveredMsgsCount={}|unAckMsgsCount={}|sendTopics={}|subscribeTopics={}|user={}", new Object[]{deliveredFailCount.longValue(), deliveredMsgsCount.longValue(), unAckMsgsCount, sendTopics, subscribeTopics, session.getClient()});
                    topicSet.addAll(session.getSessionContext().subscribeTopics.keySet());
                }
                EventMeshTcpMonitor.this.subTopicNum = topicSet.size();
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "client2eventMeshTPS", EventMeshTcpMonitor.this.client2eventMeshTPS));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "eventMesh2mqTPS", EventMeshTcpMonitor.this.eventMesh2mqTPS));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "mq2eventMeshTPS", EventMeshTcpMonitor.this.mq2eventMeshTPS));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "eventMesh2clientTPS", EventMeshTcpMonitor.this.eventMesh2clientTPS));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "allTPS", EventMeshTcpMonitor.this.allTPS));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "connection", EventMeshTcpConnectionHandler.connections));
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "subTopicNum", EventMeshTcpMonitor.this.subTopicNum));
            }
        }, delay, period, TimeUnit.MILLISECONDS);
        this.monitorThreadPoolTask = this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventMeshTcpMonitor.this.eventMeshTCPServer.getEventMeshTcpRetryer().printRetryThreadPoolState();
                int retrySize = EventMeshTcpMonitor.this.eventMeshTCPServer.getEventMeshTcpRetryer().getRetrySize();
                EventMeshTcpMonitor.this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "retryQueueSize", retrySize));
            }
        }, 10L, PRINT_THREADPOOLSTATE_INTERVAL, TimeUnit.SECONDS);
        this.logger.info("EventMeshTcpMonitor started......");
    }

    public void shutdown() throws Exception {
        this.monitorTpsTask.cancel(true);
        this.monitorThreadPoolTask.cancel(true);
        this.logger.info("EventMeshTcpMonitor shutdown......");
    }

    public AtomicInteger getClient2EventMeshMsgNum() {
        return this.client2eventMeshMsgNum;
    }

    public AtomicInteger getEventMesh2mqMsgNum() {
        return this.eventMesh2mqMsgNum;
    }

    public AtomicInteger getMq2EventMeshMsgNum() {
        return this.mq2eventMeshMsgNum;
    }

    public AtomicInteger getEventMesh2clientMsgNum() {
        return this.eventMesh2clientMsgNum;
    }
}

