/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.http;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.metrics.http.GroupMetrics;
import org.apache.eventmesh.runtime.metrics.http.HealthMetrics;
import org.apache.eventmesh.runtime.metrics.http.SummaryMetrics;
import org.apache.eventmesh.runtime.metrics.http.TopicMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMetricsServer {
    private EventMeshHTTPServer eventMeshHTTPServer;
    private MetricRegistry metricRegistry = new MetricRegistry();
    public SummaryMetrics summaryMetrics;
    public HealthMetrics healthMetrics;
    public TopicMetrics topicMetrics;
    public GroupMetrics groupMetrics;
    private Logger httpLogger = LoggerFactory.getLogger((String)"httpMonitor");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static ScheduledExecutorService metricsSchedule = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private AtomicInteger seq = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            this.seq.incrementAndGet();
            Thread t = new Thread(r, "eventMesh-metrics-" + this.seq.get());
            t.setDaemon(true);
            return t;
        }
    });

    public HTTPMetricsServer(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void init() throws Exception {
        this.summaryMetrics = new SummaryMetrics(this.eventMeshHTTPServer, this.metricRegistry);
        this.topicMetrics = new TopicMetrics(this.eventMeshHTTPServer, this.metricRegistry);
        this.groupMetrics = new GroupMetrics(this.eventMeshHTTPServer, this.metricRegistry);
        this.healthMetrics = new HealthMetrics(this.eventMeshHTTPServer, this.metricRegistry);
        this.logger.info("HTTPMetricsServer inited......");
    }

    public void start() throws Exception {
        metricsSchedule.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPMetricsServer.this.summaryMetrics.snapshotHTTPTPS();
                    HTTPMetricsServer.this.summaryMetrics.snapshotSendBatchMsgTPS();
                    HTTPMetricsServer.this.summaryMetrics.snapshotSendMsgTPS();
                    HTTPMetricsServer.this.summaryMetrics.snapshotPushMsgTPS();
                }
                catch (Exception ex) {
                    HTTPMetricsServer.this.logger.warn("eventMesh snapshot tps metrics err", (Throwable)ex);
                }
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        metricsSchedule.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPMetricsServer.this.logPrintServerMetrics();
                }
                catch (Exception ex) {
                    HTTPMetricsServer.this.logger.warn("eventMesh print metrics err", (Throwable)ex);
                }
            }
        }, 1000L, 30000L, TimeUnit.MILLISECONDS);
        this.logger.info("HTTPMetricsServer started......");
    }

    public void shutdown() throws Exception {
        metricsSchedule.shutdown();
        this.logger.info("HTTPMetricsServer shutdown......");
    }

    private void logPrintServerMetrics() {
        this.httpLogger.info("===========================================SERVER METRICS==================================================");
        this.httpLogger.info(String.format("{\"maxHTTPTPS\":\"%.1f\",\"avgHTTPTPS\":\"%.1f\",\"maxHTTPCOST\":\"%s\",\"avgHTTPCOST\":\"%.1f\",\"avgHTTPBodyDecodeCost\":\"%.1f\", \"httpDiscard\":\"%s\"}", Float.valueOf(this.summaryMetrics.maxHTTPTPS()), Float.valueOf(this.summaryMetrics.avgHTTPTPS()), this.summaryMetrics.maxHTTPCost(), Float.valueOf(this.summaryMetrics.avgHTTPCost()), Float.valueOf(this.summaryMetrics.avgHTTPBodyDecodeCost()), this.summaryMetrics.getHttpDiscard()));
        this.summaryMetrics.httpStatInfoClear();
        this.httpLogger.info(String.format("{\"maxBatchSendMsgTPS\":\"%.1f\",\"avgBatchSendMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.2f\", \"discard\":\"%s\"}", Float.valueOf(this.summaryMetrics.maxSendBatchMsgTPS()), Float.valueOf(this.summaryMetrics.avgSendBatchMsgTPS()), this.summaryMetrics.getSendBatchMsgNumSum(), this.summaryMetrics.getSendBatchMsgFailNumSum(), Float.valueOf(this.summaryMetrics.getSendBatchMsgFailRate()), this.summaryMetrics.getSendBatchMsgDiscardNumSum()));
        this.summaryMetrics.cleanSendBatchStat();
        this.httpLogger.info(String.format("{\"maxSendMsgTPS\":\"%.1f\",\"avgSendMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.2f\", \"replyMsg\":\"%s\", \"replyFail\":\"%s\"}", Float.valueOf(this.summaryMetrics.maxSendMsgTPS()), Float.valueOf(this.summaryMetrics.avgSendMsgTPS()), this.summaryMetrics.getSendMsgNumSum(), this.summaryMetrics.getSendMsgFailNumSum(), Float.valueOf(this.summaryMetrics.getSendMsgFailRate()), this.summaryMetrics.getReplyMsgNumSum(), this.summaryMetrics.getReplyMsgFailNumSum()));
        this.summaryMetrics.cleanSendMsgStat();
        this.httpLogger.info(String.format("{\"maxPushMsgTPS\":\"%.1f\",\"avgPushMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.1f\", \"maxClientLatency\":\"%.1f\", \"avgClientLatency\":\"%.1f\"}", Float.valueOf(this.summaryMetrics.maxPushMsgTPS()), Float.valueOf(this.summaryMetrics.avgPushMsgTPS()), this.summaryMetrics.getHttpPushMsgNumSum(), this.summaryMetrics.getHttpPushFailNumSum(), Float.valueOf(this.summaryMetrics.getHttpPushMsgFailRate()), Float.valueOf(this.summaryMetrics.maxHTTPPushLatency()), Float.valueOf(this.summaryMetrics.avgHTTPPushLatency())));
        this.summaryMetrics.cleanHttpPushMsgStat();
        this.httpLogger.info(String.format("{\"batchMsgQ\":\"%s\",\"sendMsgQ\":\"%s\",\"pushMsgQ\":\"%s\",\"httpRetryQ\":\"%s\"}", this.eventMeshHTTPServer.getBatchMsgExecutor().getQueue().size(), this.eventMeshHTTPServer.getSendMsgExecutor().getQueue().size(), this.eventMeshHTTPServer.getPushMsgExecutor().getQueue().size(), this.eventMeshHTTPServer.getHttpRetryer().size()));
        this.httpLogger.info(String.format("{\"batchAvgSend2MQCost\":\"%.1f\", \"avgSend2MQCost\":\"%.1f\", \"avgReply2MQCost\":\"%.1f\"}", Float.valueOf(this.summaryMetrics.avgBatchSendMsgCost()), Float.valueOf(this.summaryMetrics.avgSendMsgCost()), Float.valueOf(this.summaryMetrics.avgReplyMsgCost())));
        this.summaryMetrics.send2MQStatInfoClear();
    }

    public HealthMetrics getHealthMetrics() {
        return this.healthMetrics;
    }

    public TopicMetrics getTopicMetrics() {
        return this.topicMetrics;
    }

    public GroupMetrics getGroupMetrics() {
        return this.groupMetrics;
    }
}

