/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTransferTask
extends AbstractTask {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final int TRY_PERMIT_TIME_OUT = 5;

    public MessageTransferTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            final long taskExecuteTime = System.currentTimeMillis();
            Command cmd = this.pkg.getHeader().getCommand();
            Command replyCmd = this.getReplyCmd(cmd);
            final Package msg = new Package();
            EventMeshMessage eventMeshMessage = (EventMeshMessage)this.pkg.getBody();
            boolean retCode = false;
            try {
                if (eventMeshMessage == null) {
                    throw new Exception("eventMeshMessage is null");
                }
                if (!cmd.equals((Object)Command.RESPONSE_TO_SERVER) && !this.eventMeshTCPServer.getRateLimiter().tryAcquire(5L, TimeUnit.MILLISECONDS)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), "Tps overload, global flow control", this.pkg.getHeader().getSeq()));
                    this.ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Utils.logSucceedMessageFlow(msg, MessageTransferTask.this.session.getClient(), MessageTransferTask.this.startTime, taskExecuteTime);
                        }
                    });
                    this.logger.warn("======Tps overload, global flow control, rate:{}! PLEASE CHECK!========", (Object)this.eventMeshTCPServer.getRateLimiter().getRate());
                    return;
                }
                Session session = this.session;
                synchronized (session) {
                    long sendTime = System.currentTimeMillis();
                    this.addTimestamp(eventMeshMessage, cmd, sendTime);
                    EventMeshTcpSendResult sendStatus = this.session.upstreamMsg(this.pkg.getHeader(), EventMeshUtil.decodeMessage(eventMeshMessage), this.createSendCallback(replyCmd, taskExecuteTime, eventMeshMessage), this.startTime, taskExecuteTime);
                    if (!StringUtils.equals((CharSequence)EventMeshTcpSendStatus.SUCCESS.name(), (CharSequence)sendStatus.getSendStatus().name())) {
                        throw new Exception(sendStatus.getDetail());
                    }
                    this.messageLogger.info("pkg|eventMesh2mq|cmd={}|Msg={}|user={}|wait={}ms|cost={}ms", new Object[]{cmd, EventMeshUtil.printMqMessage(eventMeshMessage), this.session.getClient(), taskExecuteTime - this.startTime, sendTime - this.startTime});
                }
            }
            catch (Exception e) {
                this.logger.error("MessageTransferTask failed|cmd={}|Msg={}|user={}|errMsg={}", new Object[]{cmd, eventMeshMessage, this.session.getClient(), e});
                if (cmd.equals((Object)Command.RESPONSE_TO_SERVER)) break block8;
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), e.getStackTrace().toString(), this.pkg.getHeader().getSeq()));
                Utils.writeAndFlush(msg, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
            }
        }
    }

    private void addTimestamp(EventMeshMessage eventMeshMessage, Command cmd, long sendTime) {
        if (cmd.equals((Object)Command.RESPONSE_TO_SERVER)) {
            eventMeshMessage.getProperties().put("rsp_c2eventMesh_timestamp", String.valueOf(this.startTime));
            eventMeshMessage.getProperties().put("rsp_eventMesh2mq_timestamp", String.valueOf(sendTime));
            eventMeshMessage.getProperties().put("rsp_send_eventMesh_ip", this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerIp);
        } else {
            eventMeshMessage.getProperties().put("req_c2eventMesh_timestamp", String.valueOf(this.startTime));
            eventMeshMessage.getProperties().put("req_eventMesh2mq_timestamp", String.valueOf(sendTime));
            eventMeshMessage.getProperties().put("req_send_eventMesh_ip", this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerIp);
        }
    }

    private Command getReplyCmd(Command cmd) {
        switch (cmd) {
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }

    protected SendCallback createSendCallback(final Command replyCmd, final long taskExecuteTime, final EventMeshMessage eventMeshMessage) {
        final long createTime = System.currentTimeMillis();
        final Package msg = new Package();
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                MessageTransferTask.this.session.getSender().getUpstreamBuff().release();
                MessageTransferTask.this.messageLogger.info("upstreamMsg message success|user={}|callback cost={}", (Object)MessageTransferTask.this.session.getClient(), (Object)String.valueOf(System.currentTimeMillis() - createTime));
                if (replyCmd.equals((Object)Command.BROADCAST_MESSAGE_TO_SERVER_ACK) || replyCmd.equals((Object)Command.ASYNC_MESSAGE_TO_SERVER_ACK)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), MessageTransferTask.this.pkg.getHeader().getSeq()));
                    msg.setBody((Object)eventMeshMessage);
                    Utils.writeAndFlush(msg, MessageTransferTask.this.startTime, taskExecuteTime, MessageTransferTask.this.session.getContext(), MessageTransferTask.this.session);
                }
            }

            public void onException(OnExceptionContext context) {
                MessageTransferTask.this.session.getSender().getUpstreamBuff().release();
                MessageTransferTask.this.session.getSender().failMsgCount.incrementAndGet();
                MessageTransferTask.this.messageLogger.error("upstreamMsg mq message error|user={}|callback cost={}, errMsg={}", new Object[]{MessageTransferTask.this.session.getClient(), String.valueOf(System.currentTimeMillis() - createTime), new Exception((Throwable)context.getException())});
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), context.getException().toString(), MessageTransferTask.this.pkg.getHeader().getSeq()));
                msg.setBody((Object)eventMeshMessage);
                Utils.writeAndFlush(msg, MessageTransferTask.this.startTime, taskExecuteTime, MessageTransferTask.this.session.getContext(), MessageTransferTask.this.session);
            }
        };
    }
}

